/*
 * Decompiled with CFR 0.152.
 */
package parser;

import parser.Symbols;

abstract class Parser {
    Parser() {
    }

    void parse(String s) throws Exception {
        StringBuffer expression = Parser.removeChars(new StringBuffer(s));
        int valIdx = -1;
        int braceCtr = 0;
        block0: for (int i = 0; i < expression.length(); ++i) {
            char pc = i > 0 ? expression.charAt(i - 1) : (char)'\u0000';
            char c = expression.charAt(i);
            for (char op : new char[]{'+', '-'}) {
                if (c != op) continue;
                if (i == 0 || pc == '(' || pc == '{' || pc == '[') {
                    this.number("0");
                } else {
                    if (pc == 'E' || pc == 'e') continue block0;
                    if (Character.isLetterOrDigit(pc)) {
                        this.parse(valIdx, i, expression);
                        valIdx = -1;
                    }
                }
                this.operator(op + "");
                continue block0;
            }
            for (char op : new char[]{'*', '/', '^', '!'}) {
                if (c != op) continue;
                this.parse(valIdx, i, expression);
                valIdx = -1;
                this.operator(op + "");
                continue block0;
            }
            char[] br = new char[]{'(', '[', '{', ')', ']', '}'};
            for (int k = 0; k < br.length; k = (int)((byte)(k + 1))) {
                if (c != br[k]) continue;
                this.parse(valIdx, i, expression);
                valIdx = -1;
                if (k < 3) {
                    this.openBrace();
                    ++braceCtr;
                    continue block0;
                }
                if (--braceCtr < 0) {
                    throw new Exception("Missing opening brace");
                }
                this.closeBrace();
                continue block0;
            }
            if (Character.isLetterOrDigit(c) || c == '.') {
                if (valIdx != -1) continue;
                valIdx = i;
                continue;
            }
            throw new Exception("Unknown symbol: " + c);
        }
        if (braceCtr > 0) {
            throw new Exception("Missing closing brace");
        }
        this.parse(valIdx, expression.length(), expression);
    }

    private static StringBuffer removeChars(StringBuffer sb) {
        String[] delList;
        for (String str : delList = new String[]{" ", "\n", "\t", "\b", "\f", "\r"}) {
            while (sb.indexOf(str) != -1) {
                sb.deleteCharAt(sb.indexOf(str));
            }
        }
        return sb;
    }

    private void parse(int valIdx, int idx, StringBuffer expr) throws Exception {
        if (valIdx != -1) {
            String s = expr.substring(valIdx, idx);
            if (s == null || s.compareTo("") == 0) {
                throw new Exception("Error while parsing expression " + expr);
            }
            if (Symbols.isFunction(s)) {
                this.function(s);
            } else if (Character.isLetter(s.charAt(0))) {
                this.variable(s);
            } else if (Character.isDigit(s.charAt(0))) {
                try {
                    this.number(s);
                }
                catch (Exception e) {
                    String msg = "Invalid expression: " + s + ".\nMaybe a * symbol is missing.";
                    throw new Exception(msg);
                }
            }
        }
    }

    abstract void openBrace();

    abstract void closeBrace();

    abstract void operator(String var1) throws Exception;

    abstract void variable(String var1);

    abstract void function(String var1);

    abstract void number(String var1) throws Exception;
}

