/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import math.VecMath;
import parser.Expression;
import parser.Symbols;

final class OperatorExpression<T extends Number>
extends Expression<T> {
    private ArrayList<String> operators = new ArrayList();

    OperatorExpression(VecMath<T> mt) {
        super(mt);
    }

    @Override
    T getValue() throws Exception {
        int binOpCnt = this.operators.size();
        for (String op : this.operators) {
            if (!Symbols.isUnary(op)) continue;
            --binOpCnt;
        }
        if (binOpCnt + 1 != this.getChildCount()) {
            throw new Exception("Bad operator expression");
        }
        ArrayList vals = new ArrayList();
        for (int i = 0; i < this.getChildCount(); ++i) {
            vals.add(this.getChild(i).getValue());
        }
        ArrayList<String> ops = new ArrayList<String>(this.operators);
        while (ops.size() > 0) {
            int[] opPos = Symbols.precedence(ops);
            String op = ops.remove(opPos[0]);
            Number arg1 = (Number)vals.remove(opPos[0]);
            Number arg2 = null;
            if (!Symbols.isUnary(op)) {
                arg2 = (Number)vals.remove(opPos[0]);
            }
            Object res = this.calculate(op, arg1, arg2);
            vals.add(opPos[0], res);
        }
        return (T)((Number)vals.get(0));
    }

    private T calculate(String op, T arg1, T arg2) throws Exception {
        if (op.compareTo("*") == 0) {
            return this.math.mul(arg1, arg2);
        }
        if (op.compareTo("/") == 0) {
            return this.math.div(arg1, arg2);
        }
        if (op.compareTo("+") == 0) {
            return this.math.add(arg1, arg2);
        }
        if (op.compareTo("-") == 0) {
            return this.math.sub(arg1, arg2);
        }
        if (op.compareTo("^") == 0) {
            int iarg2 = ((Number)arg2).intValue();
            if (this.math.cmp(arg2, this.math.util.cast(iarg2)) == 0) {
                return this.math.pow(arg1, iarg2);
            }
            return this.math.pow(arg1, arg2);
        }
        if (op.compareTo("!") == 0) {
            if (this.math.cmp(arg1, this.math.util.round(arg1, 1)) != 0) {
                throw new Exception("Can't calculate the faculty of non-integers");
            }
            if (this.math.cmp(arg1, this.math.ZERO) < 0) {
                throw new Exception("Can't calculate the faculty of negative integers");
            }
            Object res = this.math.ONE;
            for (long i = 2L; i <= ((Number)arg1).longValue(); ++i) {
                res = this.math.mul(res, this.math.util.cast(i));
            }
            return this.math.util.copy(res, Integer.MAX_VALUE);
        }
        throw new Exception("Unknown operator " + op);
    }

    void addOperator(String op) {
        this.operators.add(op);
    }
}

