/*
 * Decompiled with CFR 0.152.
 */
package parser;

import math.VecMath;
import parser.Expression;

final class FunctionExpression<T extends Number>
extends Expression<T> {
    private String f;

    FunctionExpression(String function, VecMath<T> math) {
        super(math);
        this.f = function;
    }

    @Override
    T getValue() throws Exception {
        if (this.getChildCount() == 0) {
            throw new Exception("Function " + this.f + " has no arguments.");
        }
        if (this.getChildCount() > 1) {
            throw new Exception("Function " + this.f + " has more than one argument.");
        }
        T retVal = null;
        Object arg = this.getChild(0).getValue();
        if (this.f.compareTo("sin") == 0) {
            retVal = this.math.sin(arg);
        } else if (this.f.compareTo("cos") == 0) {
            retVal = this.math.cos(arg);
        } else if (this.f.compareTo("tan") == 0) {
            retVal = this.math.tan(arg);
        } else if (this.f.compareTo("arcsin") == 0) {
            retVal = this.math.asin(arg);
        } else if (this.f.compareTo("arccos") == 0) {
            retVal = this.math.acos(arg);
        } else if (this.f.compareTo("arctan") == 0) {
            retVal = this.math.atan(arg);
        } else if (this.f.compareTo("ln") == 0) {
            retVal = this.math.log(arg);
        } else if (this.f.compareTo("sqrt") == 0) {
            retVal = this.math.sqrt(arg);
        }
        return retVal;
    }
}

