/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.LinkedList;
import math.VecMath;
import parser.Expression;
import parser.ExpressionTree;
import parser.FunctionExpression;
import parser.OperatorExpression;
import parser.Parser;
import parser.ValueExpression;

public class ExpressionTreeBuilder<T extends Number>
extends Parser {
    private final LinkedList<Expression<T>> expressions;
    private final VecMath<T> math;

    public ExpressionTreeBuilder(VecMath<T> mt) {
        this.math = mt;
        this.expressions = new LinkedList();
    }

    public ExpressionTree<T> build(String mathExpr) throws Exception {
        OperatorExpression<T> root = new OperatorExpression<T>(this.math);
        ExpressionTree<T> tree = new ExpressionTree<T>(root);
        this.expressions.clear();
        this.expressions.add(root);
        this.parse(mathExpr);
        return tree;
    }

    @Override
    void closeBrace() {
        this.expressions.removeLast();
        Expression<T> expr = this.expressions.getLast();
        if (expr instanceof FunctionExpression) {
            this.expressions.removeLast();
        }
    }

    @Override
    void openBrace() {
        OperatorExpression<T> op = new OperatorExpression<T>(this.math);
        Expression<T> expr = this.expressions.getLast();
        expr.addChild(op);
        this.expressions.add(op);
    }

    @Override
    void operator(String op) throws Exception {
        Expression<T> expr = this.expressions.getLast();
        if (!(expr instanceof OperatorExpression)) {
            throw new Exception("Bad expression at operator " + op);
        }
        ((OperatorExpression)expr).addOperator(op);
    }

    @Override
    void function(String f) {
        FunctionExpression<T> funct = new FunctionExpression<T>(f, this.math);
        Expression<T> expr = this.expressions.getLast();
        expr.addChild(funct);
        this.expressions.add(funct);
    }

    @Override
    void number(String val) throws Exception {
        Object t;
        try {
            t = this.math.util.parse(val);
            t = this.math.util.copy(t, this.math.PRECISION + 100);
        }
        catch (Exception e) {
            throw new Exception("Can't parse number " + val + "\n.");
        }
        ValueExpression value = new ValueExpression(t);
        Expression expr = this.expressions.getLast();
        expr.addChild(value);
    }

    @Override
    void variable(String v) {
        ValueExpression value = new ValueExpression(v);
        Expression expr = this.expressions.getLast();
        expr.addChild(value);
    }
}

