/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;
import parser.Expression;
import parser.ValueExpression;

public final class ExpressionTree<T extends Number> {
    private final Expression<T> root;

    public ExpressionTree(Expression<T> root) {
        this.root = root;
    }

    public T calculate(HashMap<String, T> map) throws Exception {
        Collection<Expression<T>> exprs = this.getExpressions();
        for (Expression<T> expr : exprs) {
            if (!(expr instanceof ValueExpression) || this.insert(map, (ValueExpression)expr)) continue;
            String var = ((ValueExpression)expr).getVariable();
            throw new Exception("Variable " + var + " has no value.");
        }
        return this.root.getValue();
    }

    public T calculate(String args, T[] values) throws Exception {
        return this.calculate(this.buildValueMap(args, (Number[])values));
    }

    private boolean insert(HashMap<String, T> varVals, ValueExpression<T> value) {
        boolean ok = false;
        if (value.getVariable() != null) {
            if (value.getVariable().compareTo("e") == 0) {
                value.setValue((Number)this.root.math.util.getE(this.root.math.PRECISION + 100));
                ok = true;
            } else if (value.getVariable().compareTo("pi") == 0) {
                value.setValue((Number)this.root.math.util.getPi(this.root.math.PRECISION + 100));
                ok = true;
            } else {
                for (String var : varVals.keySet()) {
                    if (value.getVariable().compareTo(var) != 0) continue;
                    value.setValue((Number)varVals.get(var));
                    ok = true;
                    break;
                }
            }
        } else {
            ok = true;
        }
        return ok;
    }

    public Expression<T> getRoot() {
        return this.root;
    }

    public Collection<Expression<T>> getExpressions() {
        ArrayList<Expression<T>> nodeList = new ArrayList<Expression<T>>();
        this.addNodes(this.root, nodeList);
        return nodeList;
    }

    private void addNodes(Expression<T> expr, Collection<Expression<T>> exprList) {
        exprList.add(expr);
        for (int i = 0; i < expr.getChildCount(); ++i) {
            this.addNodes(expr.getChild(i), exprList);
        }
    }

    public HashMap<String, T> buildValueMap(String args, T[] values) throws Exception {
        HashMap retVal = new HashMap();
        StringTokenizer st = null;
        if (args != null) {
            st = new StringTokenizer(args.trim(), ",");
        }
        while (st != null && st.hasMoreTokens()) {
            String paramDef = st.nextToken();
            int idx = paramDef.indexOf("=");
            if (idx != -1) {
                Object value;
                String key = paramDef.substring(0, idx).trim();
                String val = paramDef.substring(idx + 1).trim();
                if (key == null || key.compareTo("") == 0) {
                    throw new Exception("Mising parameter: " + paramDef);
                }
                if (val == null || val.compareTo("") == 0) {
                    throw new Exception("Mising value: " + paramDef);
                }
                int pr = this.root.math.PRECISION + 100;
                if (val.indexOf("$") == 0) {
                    int row;
                    try {
                        row = Integer.parseInt(val.substring(1)) - 1;
                    }
                    catch (Exception e) {
                        throw new Exception("$ must be followed by an integer");
                    }
                    if (row >= values.length) {
                        throw new Exception("Value reference points to an subsequent row");
                    }
                    value = values[row];
                    if (value == null) {
                        throw new Exception("Value reference points to an empty row");
                    }
                    if (this.root.math.util.precision(value) > pr) {
                        value = this.root.math.util.copy(value, pr);
                    }
                } else if (val.compareTo("e") == 0) {
                    value = this.root.math.util.getE(this.root.math.PRECISION + 100);
                } else if (val.compareTo("pi") == 0) {
                    value = this.root.math.util.getPi(this.root.math.PRECISION + 100);
                } else {
                    try {
                        value = this.root.math.util.parse(val);
                        value = this.root.math.util.copy(value, this.root.math.PRECISION + 100);
                    }
                    catch (Exception e) {
                        throw new Exception("Can't parse number: " + paramDef);
                    }
                }
                retVal.put(key, value);
                continue;
            }
            throw new Exception("Missing = in parameter list: " + paramDef);
        }
        return retVal;
    }

    public boolean containsVariable(String var) {
        Collection<Expression<T>> exprs = this.getExpressions();
        for (Expression<T> expr : exprs) {
            ValueExpression valExpr;
            String v;
            if (!(expr instanceof ValueExpression) || (v = (valExpr = (ValueExpression)expr).getVariable()) == null || v.compareTo(var) != 0) continue;
            return true;
        }
        return false;
    }
}

