/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.spi;

public class Util {
    private Util() {
    }

    public static int round2down(int n) {
        assert (n >= 0);
        return Integer.highestOneBit(n);
    }

    public static long round2down(long l) {
        assert (l >= 0L);
        return Long.highestOneBit(l);
    }

    public static int round2up(int n) {
        int n2;
        assert (n >= 0);
        assert (n <= 0x40000000);
        if (n == 0) {
            return 0;
        }
        for (n2 = 1; n2 < n; n2 += n2) {
        }
        return n2;
    }

    public static long round2up(long l) {
        long l2;
        assert (l >= 0L);
        assert (l <= 0x4000000000000000L);
        if (l == 0L) {
            return 0L;
        }
        for (l2 = 1L; l2 < l; l2 += l2) {
        }
        return l2;
    }

    public static int round23down(int n) {
        assert (n >= 0);
        if (n == 0) {
            return 0;
        }
        int n2 = 1;
        int n3 = 0;
        while (n2 <= n && n2 > 0) {
            n3 = n2;
            if (n2 == 1) {
                n2 = 2;
                continue;
            }
            if (n2 == (n2 & -n2)) {
                n2 = n2 / 2 * 3;
                continue;
            }
            n2 = n2 / 3 * 4;
        }
        return n3;
    }

    public static long round23down(long l) {
        assert (l >= 0L);
        if (l == 0L) {
            return 0L;
        }
        long l2 = 1L;
        long l3 = 0L;
        while (l2 <= l && l2 > 0L) {
            l3 = l2;
            if (l2 == 1L) {
                l2 = 2L;
                continue;
            }
            if (l2 == (l2 & -l2)) {
                l2 = l2 / 2L * 3L;
                continue;
            }
            l2 = l2 / 3L * 4L;
        }
        return l3;
    }

    public static int round23up(int n) {
        assert (n >= 0);
        assert (n <= 0x60000000);
        if (n == 0) {
            return 0;
        }
        int n2 = 1;
        while (n2 < n) {
            if (n2 == 1) {
                n2 = 2;
                continue;
            }
            if (n2 == (n2 & -n2)) {
                n2 = n2 / 2 * 3;
                continue;
            }
            n2 = n2 / 3 * 4;
        }
        return n2;
    }

    public static long round23up(long l) {
        assert (l >= 0L);
        assert (l <= 0x6000000000000000L);
        if (l == 0L) {
            return 0L;
        }
        long l2 = 1L;
        while (l2 < l) {
            if (l2 == 1L) {
                l2 = 2L;
                continue;
            }
            if (l2 == (l2 & -l2)) {
                l2 = l2 / 2L * 3L;
                continue;
            }
            l2 = l2 / 3L * 4L;
        }
        return l2;
    }

    public static int sqrt4down(int n) {
        assert (n >= 0);
        if (n == 0) {
            return 0;
        }
        int n2 = 1;
        while ((n >>= 2) > 0) {
            n2 <<= 1;
        }
        return n2;
    }

    public static long sqrt4down(long l) {
        assert (l >= 0L);
        if (l == 0L) {
            return 0L;
        }
        long l2 = 1L;
        while ((l >>= 2) > 0L) {
            l2 <<= 1;
        }
        return l2;
    }

    public static int sqrt4up(int n) {
        assert (n >= 0);
        if (n == 0) {
            return 0;
        }
        int n2 = 1;
        int n3 = 1;
        while (n3 < n && n3 > 0) {
            n3 <<= 2;
            n2 <<= 1;
        }
        return n2;
    }

    public static long sqrt4up(long l) {
        assert (l >= 0L);
        if (l == 0L) {
            return 0L;
        }
        long l2 = 1L;
        long l3 = 1L;
        while (l3 < l && l3 > 0L) {
            l3 <<= 2;
            l2 <<= 1;
        }
        return l2;
    }

    public static int log2down(int n) {
        assert (n > 0);
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    public static int log2down(long l) {
        assert (l > 0L);
        return 63 - Long.numberOfLeadingZeros(l);
    }

    public static int log2up(int n) {
        assert (n > 0);
        return Util.log2down(n) + (n == (n & -n) ? 0 : 1);
    }

    public static int log2up(long l) {
        assert (l > 0L);
        return Util.log2down(l) + (l == (l & -l) ? 0 : 1);
    }

    public static long ifFinite(long l, long l2) {
        return l == Long.MAX_VALUE || l2 <= 0L ? Long.MAX_VALUE : l2;
    }
}

