/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.spi;

import java.io.Serializable;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.spi.ArrayAccess;

public abstract class DataStorage
implements Serializable {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;
    private static final long serialVersionUID = 1862028601696578467L;
    private long offset;
    private long length;
    private DataStorage originalDataStorage;
    private boolean isReadOnly;
    private boolean isSubsequenced;

    protected DataStorage() {
        this.offset = 0L;
        this.length = 0L;
        this.originalDataStorage = null;
        this.isReadOnly = false;
        this.isSubsequenced = false;
    }

    protected DataStorage(DataStorage dataStorage, long l, long l2) {
        this.offset = l;
        this.length = l2;
        this.originalDataStorage = dataStorage;
    }

    public final DataStorage subsequence(long l, long l2) throws IllegalArgumentException, ApfloatRuntimeException {
        if (l < 0L || l2 <= 0L || l + l2 < 0L || l + l2 > this.getSize()) {
            throw new IllegalArgumentException("Requested subsequence out of range: offset=" + l + ", length=" + l2 + ", available=" + this.getSize());
        }
        this.setSubsequenced();
        if (l == 0L && l2 == this.getSize()) {
            return this;
        }
        return this.implSubsequence(l, l2);
    }

    protected abstract DataStorage implSubsequence(long var1, long var3) throws ApfloatRuntimeException;

    public final void copyFrom(DataStorage dataStorage) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
        this.copyFrom(dataStorage, dataStorage.getSize());
    }

    public final void copyFrom(DataStorage dataStorage, long l) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
        if (l <= 0L) {
            throw new IllegalArgumentException("Illegal size: " + l);
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException("Cannot copy to read-only object");
        }
        if (this.isSubsequenced()) {
            throw new IllegalStateException("Cannot copy to when subsequences exist");
        }
        this.implCopyFrom(dataStorage, l);
    }

    protected abstract void implCopyFrom(DataStorage var1, long var2) throws ApfloatRuntimeException;

    public final long getSize() throws ApfloatRuntimeException {
        if (this.isReadOnly() || this.isSubsequenced()) {
            return this.length;
        }
        return this.implGetSize();
    }

    protected abstract long implGetSize() throws ApfloatRuntimeException;

    public final void setSize(long l) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
        if (l <= 0L) {
            throw new IllegalArgumentException("Illegal size: " + l);
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException("Cannot set size of read-only object");
        }
        if (this.isSubsequenced()) {
            throw new IllegalStateException("Cannot set size when subsequences exist");
        }
        this.implSetSize(l);
    }

    protected abstract void implSetSize(long var1) throws ApfloatRuntimeException;

    public final boolean isReadOnly() {
        if (this.originalDataStorage == null) {
            return this.isReadOnly;
        }
        return this.originalDataStorage.isReadOnly();
    }

    public final void setReadOnly() throws ApfloatRuntimeException {
        if (this.isReadOnly()) {
            return;
        }
        if (!this.isSubsequenced()) {
            this.length = this.implGetSize();
        }
        if (this.originalDataStorage == null) {
            this.isReadOnly = true;
        } else {
            this.originalDataStorage.setReadOnly();
        }
    }

    public final ArrayAccess getArray(int n, long l, int n2) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
        if (this.isReadOnly() && (n & 2) != 0) {
            throw new IllegalStateException("Write access requested for read-only data storage");
        }
        if (l < 0L || n2 < 0 || l + (long)n2 < 0L || l + (long)n2 > this.getSize()) {
            throw new IllegalArgumentException("Requested block out of range: offset=" + l + ", length=" + n2 + ", available=" + this.getSize());
        }
        return this.implGetArray(n, l, n2);
    }

    protected abstract ArrayAccess implGetArray(int var1, long var2, int var4) throws ApfloatRuntimeException;

    public final ArrayAccess getTransposedArray(int n, int n2, int n3, int n4) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
        if (this.isReadOnly() && (n & 2) != 0) {
            throw new IllegalStateException("Write access requested for read-only data storage");
        }
        long l = (long)(n2 + n3) * (long)n4;
        if (n2 < 0 || n3 < 0 || n4 < 0 || n2 + n3 < 0 || l > this.getSize()) {
            throw new IllegalArgumentException("Requested block out of range: startColumn=" + n2 + ", columns=" + n3 + ", rows=" + n4 + ", available=" + this.getSize());
        }
        if (l > Integer.MAX_VALUE) {
            throw new ApfloatRuntimeException("Block too large to fit in an array: " + l);
        }
        return this.implGetTransposedArray(n, n2, n3, n4);
    }

    protected abstract ArrayAccess implGetTransposedArray(int var1, int var2, int var3, int var4) throws ApfloatRuntimeException;

    public abstract Iterator iterator(int var1, long var2, long var4) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException;

    public final boolean isSubsequenced() {
        if (this.originalDataStorage == null) {
            return this.isSubsequenced;
        }
        return true;
    }

    protected final long getOffset() {
        return this.offset;
    }

    private void setSubsequenced() throws ApfloatRuntimeException {
        if (!this.isSubsequenced()) {
            if (!this.isReadOnly()) {
                this.length = this.implGetSize();
            }
            this.isSubsequenced = true;
        }
    }

    protected abstract class AbstractIterator
    extends Iterator {
        private int mode;
        private int increment;
        private long position;
        private long length;

        protected AbstractIterator(int n, long l, long l2) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
            if (l < 0L || l2 < 0L || l > DataStorage.this.getSize() || l2 > DataStorage.this.getSize()) {
                throw new IllegalArgumentException("Requested block out of range: startPosition=" + l + ", endPosition=" + l2 + ", available=" + DataStorage.this.getSize());
            }
            if (DataStorage.this.isReadOnly() && (n & 2) != 0) {
                throw new IllegalStateException("Write access requested for read-only data storage");
            }
            this.mode = n;
            if (l2 >= l) {
                this.position = l;
                this.length = l2 - l;
                this.increment = 1;
            } else {
                this.position = l - 1L;
                this.length = l - l2;
                this.increment = -1;
            }
        }

        public boolean hasNext() {
            return this.length > 0L;
        }

        public void next() throws IllegalStateException, ApfloatRuntimeException {
            this.checkLength();
            this.position += (long)this.increment;
            --this.length;
        }

        public int getInt() throws UnsupportedOperationException, IllegalStateException, ApfloatRuntimeException {
            this.checkGet();
            return super.getInt();
        }

        public long getLong() throws UnsupportedOperationException, IllegalStateException, ApfloatRuntimeException {
            this.checkGet();
            return super.getLong();
        }

        public float getFloat() throws UnsupportedOperationException, IllegalStateException, ApfloatRuntimeException {
            this.checkGet();
            return super.getFloat();
        }

        public double getDouble() throws UnsupportedOperationException, IllegalStateException, ApfloatRuntimeException {
            this.checkGet();
            return super.getDouble();
        }

        public void setInt(int n) throws UnsupportedOperationException, IllegalStateException, ApfloatRuntimeException {
            this.checkSet();
            super.setInt(n);
        }

        public void setLong(long l) throws UnsupportedOperationException, IllegalStateException, ApfloatRuntimeException {
            this.checkSet();
            super.setLong(l);
        }

        public void setFloat(float f) throws UnsupportedOperationException, IllegalStateException, ApfloatRuntimeException {
            this.checkSet();
            super.setFloat(f);
        }

        public void setDouble(double d) throws UnsupportedOperationException, IllegalStateException, ApfloatRuntimeException {
            this.checkSet();
            super.setDouble(d);
        }

        protected void checkGet() throws IllegalStateException {
            this.checkLength();
            if ((this.mode & 1) == 0) {
                throw new IllegalStateException("Not a readable iterator");
            }
        }

        protected void checkSet() throws IllegalStateException {
            this.checkLength();
            if ((this.mode & 2) == 0) {
                throw new IllegalStateException("Not a writable iterator");
            }
        }

        protected void checkLength() throws IllegalStateException {
            if (this.length == 0L) {
                throw new IllegalStateException("At the end of iterator");
            }
        }

        protected int getMode() {
            return this.mode;
        }

        protected long getPosition() {
            return this.position;
        }

        protected long getLength() {
            return this.length;
        }

        protected int getIncrement() {
            return this.increment;
        }
    }

    public static abstract class Iterator {
        protected Iterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public void next() throws IllegalStateException, ApfloatRuntimeException {
            throw new IllegalStateException("Not implemented");
        }

        public int getInt() throws UnsupportedOperationException, IllegalStateException, ApfloatRuntimeException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public long getLong() throws UnsupportedOperationException, IllegalStateException, ApfloatRuntimeException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public float getFloat() throws UnsupportedOperationException, IllegalStateException, ApfloatRuntimeException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public double getDouble() throws UnsupportedOperationException, IllegalStateException, ApfloatRuntimeException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void setInt(int n) throws UnsupportedOperationException, IllegalStateException, ApfloatRuntimeException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void setLong(long l) throws UnsupportedOperationException, IllegalStateException, ApfloatRuntimeException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void setFloat(float f) throws UnsupportedOperationException, IllegalStateException, ApfloatRuntimeException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void setDouble(double d) throws UnsupportedOperationException, IllegalStateException, ApfloatRuntimeException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void close() throws ApfloatRuntimeException {
        }
    }
}

