/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.spi.Util;

public class ParallelRunner {
    private int numberOfProcessors;
    private Object key;
    private static final int MINIMUM_BATCH_SIZE = 16;
    private static Map<Object, ParallelRunnableTask> tasks = new IdentityHashMap<Object, ParallelRunnableTask>();

    public ParallelRunner(int n) {
        assert (n > 0);
        this.numberOfProcessors = n;
    }

    public void lock(Object object) {
        ParallelRunner.lock(object, this.numberOfProcessors);
        this.key = object;
    }

    public void unlock() {
        ParallelRunner.unlock(this.key);
    }

    public void runParallel(ParallelRunnable parallelRunnable) throws ApfloatRuntimeException {
        if (this.key != null) {
            ParallelRunner.runParallel(this.key, parallelRunnable);
        } else {
            new ParallelRunnableTask(this.numberOfProcessors).run(parallelRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lock(Object object, int n) {
        assert (n > 0);
        Map<Object, ParallelRunnableTask> map = tasks;
        synchronized (map) {
            boolean bl = false;
            ParallelRunnableTask parallelRunnableTask = null;
            while (!bl) {
                ParallelRunnableTask parallelRunnableTask2 = tasks.get(object);
                if (parallelRunnableTask2 == null) {
                    parallelRunnableTask2 = new ParallelRunnableTask(n);
                    tasks.put(object, parallelRunnableTask2);
                    bl = true;
                    continue;
                }
                if (parallelRunnableTask2 != parallelRunnableTask) {
                    parallelRunnableTask2.add(n);
                    parallelRunnableTask = parallelRunnableTask2;
                }
                try {
                    tasks.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new ApfloatInternalException("Waiting for lock notification was interrupted", interruptedException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unlock(Object object) {
        Map<Object, ParallelRunnableTask> map = tasks;
        synchronized (map) {
            ParallelRunnableTask parallelRunnableTask = tasks.remove(object);
            assert (parallelRunnableTask != null);
            tasks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runParallel(Object object, ParallelRunnable parallelRunnable) throws ApfloatRuntimeException {
        ParallelRunnableTask parallelRunnableTask;
        Map<Object, ParallelRunnableTask> map = tasks;
        synchronized (map) {
            parallelRunnableTask = tasks.get(object);
            assert (parallelRunnableTask != null);
        }
        parallelRunnableTask.run(parallelRunnable);
    }

    private static class ParallelRunnableTask
    implements Runnable {
        private int numberOfProcessors;
        private AtomicReference<ParallelRunnable> parallelRunnable;
        private AtomicInteger position;
        private volatile int batchSize;
        private List<Future<?>> futures;

        public ParallelRunnableTask(int n) {
            this.numberOfProcessors = n;
            this.position = new AtomicInteger();
            this.parallelRunnable = new AtomicReference();
        }

        public synchronized void add(int n) {
            this.numberOfProcessors += n;
            if (this.parallelRunnable.get() != null) {
                this.submit(n);
            }
        }

        public void run(ParallelRunnable parallelRunnable) throws ApfloatRuntimeException {
            this.start(parallelRunnable);
            this.run();
            this.join();
        }

        public void run() {
            ParallelRunnable parallelRunnable = this.parallelRunnable.get();
            int n = parallelRunnable.getLength();
            while (this.position.get() < n) {
                int n2 = this.position.getAndAdd(this.batchSize);
                int n3 = Math.min(this.batchSize, n - n2);
                if (n3 <= 0) continue;
                Runnable runnable = parallelRunnable.getRunnable(n2, n3);
                runnable.run();
            }
        }

        private synchronized void start(ParallelRunnable parallelRunnable) {
            this.parallelRunnable.set(parallelRunnable);
            this.position.set(0);
            this.batchSize = Math.max(16, Util.sqrt4down(parallelRunnable.getLength()));
            this.submit(this.numberOfProcessors - 1);
        }

        private void submit(int n) {
            assert (Thread.holdsLock(this));
            if (n > 0) {
                if (this.futures == null) {
                    this.futures = new ArrayList();
                }
                ApfloatContext apfloatContext = ApfloatContext.getContext();
                ExecutorService executorService = apfloatContext.getExecutorService();
                for (int i = 0; i < n; ++i) {
                    Future<?> future = executorService.submit(this);
                    this.futures.add(future);
                }
            }
        }

        private synchronized void join() throws ApfloatRuntimeException {
            if (this.futures != null) {
                try {
                    for (Future<?> future : this.futures) {
                        future.get();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new ApfloatInternalException("Waiting for dispatched threads to complete was interrupted", interruptedException);
                }
                catch (ExecutionException executionException) {
                    throw new ApfloatInternalException("Thread execution failed", executionException);
                }
                this.futures = null;
            }
            this.parallelRunnable.set(null);
        }
    }
}

