/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.util.HashMap;
import java.util.Map;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagePasser<K, V> {
    private Map<K, V> messages = new HashMap();

    public synchronized void sendMessage(K k, V v) {
        assert (v != null);
        assert (!this.messages.containsKey(k));
        this.messages.put(k, v);
        this.notifyAll();
    }

    public synchronized V getMessage(K k) {
        V v = this.messages.remove(k);
        return v;
    }

    public synchronized V receiveMessage(K k) throws ApfloatRuntimeException {
        V v;
        while ((v = this.messages.remove(k)) == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new ApfloatInternalException("Wait for received message interrupted", interruptedException);
            }
        }
        return v;
    }
}

