/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.LongModConstants;
import org.apfloat.internal.LongModMath;
import org.apfloat.internal.LongScramble;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.NTTStrategy;
import org.apfloat.spi.Util;

public class LongTableFNTStrategy
extends LongModMath
implements NTTStrategy {
    public void transform(DataStorage dataStorage, int n) throws ApfloatRuntimeException {
        long l = dataStorage.getSize();
        if (l > 0x1800000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + l + " > " + 0x1800000000000L);
        }
        if (l > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l);
        }
        this.setModulus(LongModConstants.MODULUS[n]);
        long l2 = this.getForwardNthRoot(LongModConstants.PRIMITIVE_ROOT[n], l);
        long[] lArray = this.createWTable(l2, (int)l);
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l);
        this.tableFNT(arrayAccess, lArray, null);
        arrayAccess.close();
    }

    public void inverseTransform(DataStorage dataStorage, int n, long l) throws ApfloatRuntimeException {
        long l2 = dataStorage.getSize();
        if (Math.max(l2, l) > 0x1800000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(l2, l) + " > " + 0x1800000000000L);
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l2);
        }
        this.setModulus(LongModConstants.MODULUS[n]);
        long l3 = this.getInverseNthRoot(LongModConstants.PRIMITIVE_ROOT[n], l2);
        long[] lArray = this.createWTable(l3, (int)l2);
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l2);
        this.inverseTableFNT(arrayAccess, lArray, null);
        this.divideElements(arrayAccess, l);
        arrayAccess.close();
    }

    public long getTransformLength(long l) {
        return Util.round2up(l);
    }

    protected void tableFNT(ArrayAccess arrayAccess, long[] lArray, int[] nArray) throws ApfloatRuntimeException {
        long[] lArray2 = arrayAccess.getLongData();
        int n = arrayAccess.getOffset();
        int n2 = arrayAccess.getLength();
        assert (n2 == (n2 & -n2));
        if (n2 < 2) {
            return;
        }
        int n3 = 1;
        for (int i = n2 >> 1; i > 0; i >>= 1) {
            long l;
            int n4;
            int n5;
            int n6 = i << 1;
            for (n5 = n; n5 < n + n2; n5 += n6) {
                n4 = n5 + i;
                long l2 = lArray2[n5];
                l = lArray2[n4];
                lArray2[n5] = this.modAdd(l2, l);
                lArray2[n4] = this.modSubtract(l2, l);
            }
            n5 = n3;
            for (n4 = 1; n4 < i; ++n4) {
                for (int j = n + n4; j < n + n2; j += n6) {
                    int n7 = j + i;
                    l = lArray2[j];
                    long l3 = lArray2[n7];
                    lArray2[j] = this.modAdd(l, l3);
                    lArray2[n7] = this.modMultiply(lArray[n5], this.modSubtract(l, l3));
                }
                n5 += n3;
            }
            n3 <<= 1;
        }
        if (nArray != null) {
            LongScramble.scramble(lArray2, n, nArray);
        }
    }

    protected void inverseTableFNT(ArrayAccess arrayAccess, long[] lArray, int[] nArray) throws ApfloatRuntimeException {
        long[] lArray2 = arrayAccess.getLongData();
        int n = arrayAccess.getOffset();
        int n2 = arrayAccess.getLength();
        assert (n2 == (n2 & -n2));
        if (n2 < 2) {
            return;
        }
        if (nArray != null) {
            LongScramble.scramble(lArray2, n, nArray);
        }
        int n3 = n2;
        int n4 = 1;
        while (n2 > n4) {
            int n5;
            int n6;
            int n7 = n4 << 1;
            n3 >>= 1;
            for (n6 = n; n6 < n + n2; n6 += n7) {
                n5 = n6 + n4;
                long l = lArray2[n5];
                lArray2[n5] = this.modSubtract(lArray2[n6], l);
                lArray2[n6] = this.modAdd(lArray2[n6], l);
            }
            n6 = n3;
            for (n5 = 1; n5 < n4; ++n5) {
                for (int i = n + n5; i < n + n2; i += n7) {
                    int n8 = i + n4;
                    long l = this.modMultiply(lArray[n6], lArray2[n8]);
                    lArray2[n8] = this.modSubtract(lArray2[i], l);
                    lArray2[i] = this.modAdd(lArray2[i], l);
                }
                n6 += n3;
            }
            n4 = n7;
        }
    }

    private void divideElements(ArrayAccess arrayAccess, long l) throws ApfloatRuntimeException {
        long l2 = this.modDivide(1L, l);
        long[] lArray = arrayAccess.getLongData();
        int n = arrayAccess.getLength();
        int n2 = arrayAccess.getOffset();
        for (int i = 0; i < n; ++i) {
            lArray[i + n2] = this.modMultiply(lArray[i + n2], l2);
        }
    }
}

