/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.LongTableFNTStrategy;
import org.apfloat.internal.ParallelNTTStrategy;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.spi.ArrayAccess;

public abstract class LongParallelFNTStrategy
extends LongTableFNTStrategy
implements ParallelNTTStrategy {
    protected ParallelRunner parallelRunner;

    protected LongParallelFNTStrategy() {
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        this.parallelRunner = parallelRunner;
    }

    protected void multiplyElements(final ArrayAccess arrayAccess, final int n, final int n2, final int n3, final long l, final long l2) throws ApfloatRuntimeException {
        ParallelRunnable parallelRunnable = new ParallelRunnable(){

            public int getLength() {
                return n2;
            }

            public Runnable getRunnable(int n4, int n22) {
                ArrayAccess arrayAccess2 = arrayAccess.subsequence(n4 * n3, n22 * n3);
                return new MultiplyRunnable(arrayAccess2, n + n4, n22, n3, l, l2);
            }
        };
        this.parallelRunner.runParallel(parallelRunnable);
    }

    protected void transformRows(final int n, final int n2, final boolean bl, final ArrayAccess arrayAccess, final long[] lArray, final int[] nArray) throws ApfloatRuntimeException {
        ParallelRunnable parallelRunnable = new ParallelRunnable(){

            public int getLength() {
                return n2;
            }

            public Runnable getRunnable(int n3, int n22) {
                ArrayAccess arrayAccess2 = arrayAccess.subsequence(n3 * n, n22 * n);
                return new TableFNTRunnable(n, bl, arrayAccess2, lArray, nArray);
            }
        };
        this.parallelRunner.runParallel(parallelRunnable);
    }

    private class MultiplyRunnable
    implements Runnable {
        private ArrayAccess arrayAccess;
        private int startRow;
        private int rows;
        private int columns;
        private long w;
        private long scaleFactor;

        public MultiplyRunnable(ArrayAccess arrayAccess, int n, int n2, int n3, long l, long l2) {
            this.arrayAccess = arrayAccess;
            this.startRow = n;
            this.rows = n2;
            this.columns = n3;
            this.w = l;
            this.scaleFactor = l2;
        }

        public void run() {
            long[] lArray = this.arrayAccess.getLongData();
            int n = this.arrayAccess.getOffset();
            long l = LongParallelFNTStrategy.this.modPow(this.w, this.startRow);
            for (int i = 0; i < this.rows; ++i) {
                long l2 = this.scaleFactor;
                int n2 = 0;
                while (n2 < this.columns) {
                    lArray[n] = LongParallelFNTStrategy.this.modMultiply(lArray[n], l2);
                    l2 = LongParallelFNTStrategy.this.modMultiply(l2, l);
                    ++n2;
                    ++n;
                }
                l = LongParallelFNTStrategy.this.modMultiply(l, this.w);
            }
        }
    }

    private class TableFNTRunnable
    implements Runnable {
        private int length;
        private boolean isInverse;
        private ArrayAccess arrayAccess;
        private long[] wTable;
        private int[] permutationTable;

        public TableFNTRunnable(int n, boolean bl, ArrayAccess arrayAccess, long[] lArray, int[] nArray) {
            this.length = n;
            this.isInverse = bl;
            this.arrayAccess = arrayAccess;
            this.wTable = lArray;
            this.permutationTable = nArray;
        }

        public void run() {
            int n = this.arrayAccess.getLength();
            for (int i = 0; i < n; i += this.length) {
                ArrayAccess arrayAccess = this.arrayAccess.subsequence(i, this.length);
                if (this.isInverse) {
                    LongParallelFNTStrategy.this.inverseTableFNT(arrayAccess, this.wTable, this.permutationTable);
                    continue;
                }
                LongParallelFNTStrategy.this.tableFNT(arrayAccess, this.wTable, this.permutationTable);
            }
        }
    }
}

