/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.LongModConstants;
import org.apfloat.internal.LongParallelFNTStrategy;
import org.apfloat.internal.LongSixStepFNTStrategy;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.Util;

public class LongFactor3SixStepNTTStrategy
extends LongParallelFNTStrategy {
    private LongSixStepFNTStrategy factor2Strategy;

    public LongFactor3SixStepNTTStrategy(LongSixStepFNTStrategy longSixStepFNTStrategy) {
        this.factor2Strategy = longSixStepFNTStrategy;
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        super.setParallelRunner(parallelRunner);
        this.factor2Strategy.setParallelRunner(parallelRunner);
    }

    public void transform(DataStorage dataStorage, int n) throws ApfloatRuntimeException {
        long l = dataStorage.getSize();
        if (l > 0x1800000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + l + " > " + 0x1800000000000L);
        }
        if (l > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l);
        }
        int n2 = (int)(l & -l);
        if (l == (long)n2) {
            this.factor2Strategy.transform(dataStorage, n);
        } else {
            assert (l == (long)(3 * n2));
            this.setModulus(LongModConstants.MODULUS[n]);
            long l2 = this.getForwardNthRoot(LongModConstants.PRIMITIVE_ROOT[n], l);
            long l3 = this.modPow(l2, n2);
            ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l);
            ArrayAccess arrayAccess2 = arrayAccess.subsequence(0, n2);
            ArrayAccess arrayAccess3 = arrayAccess.subsequence(n2, n2);
            ArrayAccess arrayAccess4 = arrayAccess.subsequence(2 * n2, n2);
            this.transformColumns(false, arrayAccess2, arrayAccess3, arrayAccess4, n2, l2, l3);
            this.factor2Strategy.transform(arrayAccess2, n);
            this.factor2Strategy.transform(arrayAccess3, n);
            this.factor2Strategy.transform(arrayAccess4, n);
            arrayAccess.close();
        }
    }

    public void inverseTransform(DataStorage dataStorage, int n, long l) throws ApfloatRuntimeException {
        long l2 = dataStorage.getSize();
        if (Math.max(l2, l) > 0x1800000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(l2, l) + " > " + 0x1800000000000L);
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l2);
        }
        int n2 = (int)(l2 & -l2);
        if (l2 == (long)n2) {
            this.factor2Strategy.inverseTransform(dataStorage, n, l);
        } else {
            assert (l2 == (long)(3 * n2));
            this.setModulus(LongModConstants.MODULUS[n]);
            long l3 = this.getInverseNthRoot(LongModConstants.PRIMITIVE_ROOT[n], l2);
            long l4 = this.modPow(l3, n2);
            ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l2);
            ArrayAccess arrayAccess2 = arrayAccess.subsequence(0, n2);
            ArrayAccess arrayAccess3 = arrayAccess.subsequence(n2, n2);
            ArrayAccess arrayAccess4 = arrayAccess.subsequence(2 * n2, n2);
            this.factor2Strategy.inverseTransform(arrayAccess2, n, l);
            this.factor2Strategy.inverseTransform(arrayAccess3, n, l);
            this.factor2Strategy.inverseTransform(arrayAccess4, n, l);
            this.transformColumns(true, arrayAccess2, arrayAccess3, arrayAccess4, n2, l3, l4);
            arrayAccess.close();
        }
    }

    public long getTransformLength(long l) {
        return Util.round23up(l);
    }

    private void transformColumns(final boolean bl, final ArrayAccess arrayAccess, final ArrayAccess arrayAccess2, final ArrayAccess arrayAccess3, final int n, final long l, long l2) throws ApfloatRuntimeException {
        final long l3 = this.modMultiply(l, l);
        final long l4 = this.negate(this.modDivide(3L, 2L));
        final long l5 = this.modAdd(l2, this.modDivide(1L, 2L));
        ParallelRunnable parallelRunnable = new ParallelRunnable(){

            public int getLength() {
                return n;
            }

            public Runnable getRunnable(int n3, int n2) {
                return new ColumnTransformRunnable(bl, arrayAccess, arrayAccess2, arrayAccess3, n3, n2, l, l3, l4, l5);
            }
        };
        this.parallelRunner.runParallel(parallelRunnable);
    }

    private class ColumnTransformRunnable
    implements Runnable {
        private boolean isInverse;
        private ArrayAccess arrayAccess0;
        private ArrayAccess arrayAccess1;
        private ArrayAccess arrayAccess2;
        private int startColumn;
        private int columns;
        private long w;
        private long ww;
        private long w1;
        private long w2;

        public ColumnTransformRunnable(boolean bl, ArrayAccess arrayAccess, ArrayAccess arrayAccess2, ArrayAccess arrayAccess3, int n, int n2, long l, long l2, long l3, long l4) {
            this.isInverse = bl;
            this.arrayAccess0 = arrayAccess;
            this.arrayAccess1 = arrayAccess2;
            this.arrayAccess2 = arrayAccess3;
            this.startColumn = n;
            this.columns = n2;
            this.w = l;
            this.ww = l2;
            this.w1 = l3;
            this.w2 = l4;
        }

        public void run() {
            long l = LongFactor3SixStepNTTStrategy.this.modPow(this.w, this.startColumn);
            long l2 = LongFactor3SixStepNTTStrategy.this.modPow(this.ww, this.startColumn);
            long[] lArray = this.arrayAccess0.getLongData();
            long[] lArray2 = this.arrayAccess1.getLongData();
            long[] lArray3 = this.arrayAccess2.getLongData();
            int n = this.arrayAccess0.getOffset() + this.startColumn;
            int n2 = this.arrayAccess1.getOffset() + this.startColumn;
            int n3 = this.arrayAccess2.getOffset() + this.startColumn;
            for (int i = 0; i < this.columns; ++i) {
                long l3 = lArray[n + i];
                long l4 = lArray2[n2 + i];
                long l5 = lArray3[n3 + i];
                if (this.isInverse) {
                    l4 = LongFactor3SixStepNTTStrategy.this.modMultiply(l4, l);
                    l5 = LongFactor3SixStepNTTStrategy.this.modMultiply(l5, l2);
                }
                long l6 = LongFactor3SixStepNTTStrategy.this.modAdd(l4, l5);
                l5 = LongFactor3SixStepNTTStrategy.this.modSubtract(l4, l5);
                l3 = LongFactor3SixStepNTTStrategy.this.modAdd(l3, l6);
                l6 = LongFactor3SixStepNTTStrategy.this.modMultiply(l6, this.w1);
                l5 = LongFactor3SixStepNTTStrategy.this.modMultiply(l5, this.w2);
                l6 = LongFactor3SixStepNTTStrategy.this.modAdd(l6, l3);
                l4 = LongFactor3SixStepNTTStrategy.this.modAdd(l6, l5);
                l5 = LongFactor3SixStepNTTStrategy.this.modSubtract(l6, l5);
                if (!this.isInverse) {
                    l4 = LongFactor3SixStepNTTStrategy.this.modMultiply(l4, l);
                    l5 = LongFactor3SixStepNTTStrategy.this.modMultiply(l5, l2);
                }
                lArray[n + i] = l3;
                lArray2[n2 + i] = l4;
                lArray3[n3 + i] = l5;
                l = LongFactor3SixStepNTTStrategy.this.modMultiply(l, this.w);
                l2 = LongFactor3SixStepNTTStrategy.this.modMultiply(l2, this.ww);
            }
        }
    }
}

