/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.LongModConstants;
import org.apfloat.internal.LongModMath;
import org.apfloat.internal.ParallelNTTStrategy;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.NTTStrategy;
import org.apfloat.spi.Util;

public class LongFactor3NTTStrategy
extends LongModMath
implements ParallelNTTStrategy {
    private NTTStrategy factor2Strategy;

    public LongFactor3NTTStrategy(NTTStrategy nTTStrategy) {
        this.factor2Strategy = nTTStrategy;
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        if (this.factor2Strategy instanceof ParallelNTTStrategy) {
            ((ParallelNTTStrategy)this.factor2Strategy).setParallelRunner(parallelRunner);
        }
    }

    public void transform(DataStorage dataStorage, int n) throws ApfloatRuntimeException {
        long l = dataStorage.getSize();
        long l2 = l & -l;
        if (l > 0x1800000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + l + " > " + 0x1800000000000L);
        }
        if (l == l2) {
            this.factor2Strategy.transform(dataStorage, n);
        } else {
            assert (l == 3L * l2);
            this.setModulus(LongModConstants.MODULUS[n]);
            long l3 = this.getForwardNthRoot(LongModConstants.PRIMITIVE_ROOT[n], l);
            long l4 = this.modPow(l3, l2);
            DataStorage dataStorage2 = dataStorage.subsequence(0L, l2);
            DataStorage dataStorage3 = dataStorage.subsequence(l2, l2);
            DataStorage dataStorage4 = dataStorage.subsequence(2L * l2, l2);
            this.transformColumns(false, dataStorage2, dataStorage3, dataStorage4, l2, l3, l4);
            this.factor2Strategy.transform(dataStorage2, n);
            this.factor2Strategy.transform(dataStorage3, n);
            this.factor2Strategy.transform(dataStorage4, n);
        }
    }

    public void inverseTransform(DataStorage dataStorage, int n, long l) throws ApfloatRuntimeException {
        long l2 = dataStorage.getSize();
        long l3 = l2 & -l2;
        if (Math.max(l2, l) > 0x1800000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(l2, l) + " > " + 0x1800000000000L);
        }
        if (l2 == l3) {
            this.factor2Strategy.inverseTransform(dataStorage, n, l);
        } else {
            assert (l2 == 3L * l3);
            this.setModulus(LongModConstants.MODULUS[n]);
            long l4 = this.getInverseNthRoot(LongModConstants.PRIMITIVE_ROOT[n], l2);
            long l5 = this.modPow(l4, l3);
            DataStorage dataStorage2 = dataStorage.subsequence(0L, l3);
            DataStorage dataStorage3 = dataStorage.subsequence(l3, l3);
            DataStorage dataStorage4 = dataStorage.subsequence(2L * l3, l3);
            this.factor2Strategy.inverseTransform(dataStorage2, n, l);
            this.factor2Strategy.inverseTransform(dataStorage3, n, l);
            this.factor2Strategy.inverseTransform(dataStorage4, n, l);
            this.transformColumns(true, dataStorage2, dataStorage3, dataStorage4, l3, l4, l5);
        }
    }

    public long getTransformLength(long l) {
        return Util.round23up(l);
    }

    private void transformColumns(boolean bl, DataStorage dataStorage, DataStorage dataStorage2, DataStorage dataStorage3, long l, long l2, long l3) throws ApfloatRuntimeException {
        DataStorage.Iterator iterator = dataStorage.iterator(3, 0L, l);
        DataStorage.Iterator iterator2 = dataStorage2.iterator(3, 0L, l);
        DataStorage.Iterator iterator3 = dataStorage3.iterator(3, 0L, l);
        long l4 = this.modMultiply(l2, l2);
        long l5 = this.negate(this.modDivide(3L, 2L));
        long l6 = this.modAdd(l3, this.modDivide(1L, 2L));
        long l7 = 1L;
        long l8 = 1L;
        while (l > 0L) {
            long l9 = iterator.getLong();
            long l10 = iterator2.getLong();
            long l11 = iterator3.getLong();
            if (bl) {
                l10 = this.modMultiply(l10, l7);
                l11 = this.modMultiply(l11, l8);
            }
            long l12 = this.modAdd(l10, l11);
            l11 = this.modSubtract(l10, l11);
            l9 = this.modAdd(l9, l12);
            l12 = this.modMultiply(l12, l5);
            l11 = this.modMultiply(l11, l6);
            l12 = this.modAdd(l12, l9);
            l10 = this.modAdd(l12, l11);
            l11 = this.modSubtract(l12, l11);
            if (!bl) {
                l10 = this.modMultiply(l10, l7);
                l11 = this.modMultiply(l11, l8);
            }
            iterator.setLong(l9);
            iterator2.setLong(l10);
            iterator3.setLong(l11);
            iterator.next();
            iterator2.next();
            iterator3.next();
            l7 = this.modMultiply(l7, l2);
            l8 = this.modMultiply(l8, l4);
            --l;
        }
    }
}

