/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.LongDiskDataStorage;
import org.apfloat.internal.LongMemoryDataStorage;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class LongDataStorageBuilder
implements DataStorageBuilder {
    public DataStorage createDataStorage(long l) throws ApfloatRuntimeException {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        if (l <= (long)apfloatContext.getMemoryTreshold()) {
            return new LongMemoryDataStorage();
        }
        return new LongDiskDataStorage();
    }

    public DataStorage createCachedDataStorage(long l) throws ApfloatRuntimeException {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        if (l <= apfloatContext.getMaxMemoryBlockSize()) {
            return new LongMemoryDataStorage();
        }
        return new LongDiskDataStorage();
    }

    public DataStorage createDataStorage(DataStorage dataStorage) throws ApfloatRuntimeException {
        ApfloatContext apfloatContext;
        long l;
        if (dataStorage instanceof LongMemoryDataStorage && (l = dataStorage.getSize()) > (long)(apfloatContext = ApfloatContext.getContext()).getMemoryTreshold()) {
            LongDiskDataStorage longDiskDataStorage = new LongDiskDataStorage();
            longDiskDataStorage.copyFrom(dataStorage);
            dataStorage = longDiskDataStorage;
        }
        return dataStorage;
    }
}

