/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.internal.Long3NTTConvolutionStrategy;
import org.apfloat.internal.LongKaratsubaConvolutionStrategy;
import org.apfloat.internal.LongMediumConvolutionStrategy;
import org.apfloat.internal.LongShortConvolutionStrategy;
import org.apfloat.spi.ConvolutionBuilder;
import org.apfloat.spi.ConvolutionStrategy;
import org.apfloat.spi.NTTBuilder;
import org.apfloat.spi.NTTStrategy;
import org.apfloat.spi.Util;

public class LongConvolutionBuilder
implements ConvolutionBuilder {
    private static final double LOG2_3 = Math.log(3.0) / Math.log(2.0);

    public ConvolutionStrategy createConvolution(int n, long l, long l2, long l3) {
        float f;
        long l4 = Math.min(l, l2);
        long l5 = Math.max(l, l2);
        long l6 = l + l2;
        if (l4 == 1L) {
            return new LongShortConvolutionStrategy(n);
        }
        if (l4 <= 15L) {
            return new LongMediumConvolutionStrategy(n);
        }
        float f2 = (float)l4 * (float)l5;
        float f3 = 4.9f * (float)Math.pow(l4, LOG2_3) * (float)l5 / (float)l4;
        if (f2 <= Math.min(f3, f = 8.3f * (float)l6 * (float)Util.log2down(l6))) {
            return new LongMediumConvolutionStrategy(n);
        }
        if (f3 <= f) {
            return new LongKaratsubaConvolutionStrategy(n);
        }
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        NTTBuilder nTTBuilder = apfloatContext.getBuilderFactory().getNTTBuilder();
        NTTStrategy nTTStrategy = nTTBuilder.createNTT(l6);
        return new Long3NTTConvolutionStrategy(n, nTTStrategy);
    }
}

