/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.math.BigInteger;
import java.util.RandomAccess;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.LongCRTMath;
import org.apfloat.internal.LongModConstants;
import org.apfloat.internal.LongModMath;
import org.apfloat.internal.MessagePasser;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class LongCarryCRT
extends LongCRTMath {
    private static final long serialVersionUID = -3954870352092656433L;
    private static final LongModMath MATH_MOD_0 = new LongModMath();
    private static final LongModMath MATH_MOD_1 = new LongModMath();
    private static final LongModMath MATH_MOD_2 = new LongModMath();
    private static final long T0;
    private static final long T1;
    private static final long T2;
    private static final long[] M01;
    private static final long[] M02;
    private static final long[] M12;
    private static final long[] M012;
    private ParallelRunner parallelRunner;

    public LongCarryCRT(int n) {
        super(n);
    }

    public DataStorage carryCRT(final DataStorage dataStorage, final DataStorage dataStorage2, final DataStorage dataStorage3, final long l) throws ApfloatRuntimeException {
        Object object;
        final long l2 = Math.min(l + 2L, dataStorage.getSize());
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = apfloatContext.getBuilderFactory().getDataStorageBuilder();
        final DataStorage dataStorage4 = dataStorageBuilder.createDataStorage(l * 8L);
        dataStorage4.setSize(l);
        final MessagePasser<Long, long[]> messagePasser = new MessagePasser<Long, long[]>();
        if (l2 <= Integer.MAX_VALUE && this.parallelRunner != null && dataStorage instanceof RandomAccess && dataStorage2 instanceof RandomAccess && dataStorage3 instanceof RandomAccess && dataStorage4 instanceof RandomAccess) {
            object = new ParallelRunnable(){

                public int getLength() {
                    return (int)l2;
                }

                public Runnable getRunnable(int n, int n2) {
                    return new CarryCRTRunnable(dataStorage, dataStorage2, dataStorage3, dataStorage4, l2, l, n, n2, messagePasser);
                }
            };
            this.parallelRunner.runParallel((ParallelRunnable)object);
        } else {
            new CarryCRTRunnable(dataStorage, dataStorage2, dataStorage3, dataStorage4, l2, l, 0L, l2, messagePasser).run();
        }
        object = null;
        assert ((object = messagePasser.getMessage(l2)) != null);
        assert ((object).length == 2);
        assert (object[0] == 0L);
        assert (object[1] == 0L);
        return dataStorage4;
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        this.parallelRunner = parallelRunner;
    }

    private static DataStorage.Iterator arrayIterator(final long[] lArray) {
        return new DataStorage.Iterator(){
            private int position;
            {
                this.position = lArray.length - 1;
            }

            public boolean hasNext() {
                return true;
            }

            public void next() {
                --this.position;
            }

            public long getLong() {
                assert (this.position >= 0);
                return lArray[this.position];
            }

            public void setLong(long l) {
                assert (this.position >= 0);
                lArray[this.position] = l;
            }
        };
    }

    private static DataStorage.Iterator compositeIterator(final DataStorage.Iterator iterator, final long l, final DataStorage.Iterator iterator2) {
        return new DataStorage.Iterator(){
            private long position;

            public boolean hasNext() {
                return this.position < l ? iterator.hasNext() : iterator2.hasNext();
            }

            public void next() {
                (this.position < l ? iterator : iterator2).next();
                ++this.position;
            }

            public long getLong() {
                return (this.position < l ? iterator : iterator2).getLong();
            }

            public void setLong(long l2) {
                (this.position < l ? iterator : iterator2).setLong(l2);
            }

            public void close() throws ApfloatRuntimeException {
                (this.position < l ? iterator : iterator2).close();
            }
        };
    }

    static {
        MATH_MOD_0.setModulus(LongModConstants.MODULUS[0]);
        MATH_MOD_1.setModulus(LongModConstants.MODULUS[1]);
        MATH_MOD_2.setModulus(LongModConstants.MODULUS[2]);
        BigInteger bigInteger = BigInteger.valueOf(Math.abs(0x200000000000000L));
        BigInteger bigInteger2 = BigInteger.valueOf(LongModConstants.MODULUS[0]);
        BigInteger bigInteger3 = BigInteger.valueOf(LongModConstants.MODULUS[1]);
        BigInteger bigInteger4 = BigInteger.valueOf(LongModConstants.MODULUS[2]);
        BigInteger bigInteger5 = bigInteger2.multiply(bigInteger3);
        BigInteger bigInteger6 = bigInteger2.multiply(bigInteger4);
        BigInteger bigInteger7 = bigInteger3.multiply(bigInteger4);
        T0 = bigInteger7.modInverse(bigInteger2).longValue();
        T1 = bigInteger6.modInverse(bigInteger3).longValue();
        T2 = bigInteger5.modInverse(bigInteger4).longValue();
        M01 = new long[2];
        M02 = new long[2];
        M12 = new long[2];
        M012 = new long[3];
        BigInteger[] bigIntegerArray = bigInteger5.divideAndRemainder(bigInteger);
        LongCarryCRT.M01[0] = bigIntegerArray[0].longValue();
        LongCarryCRT.M01[1] = bigIntegerArray[1].longValue();
        bigIntegerArray = bigInteger6.divideAndRemainder(bigInteger);
        LongCarryCRT.M02[0] = bigIntegerArray[0].longValue();
        LongCarryCRT.M02[1] = bigIntegerArray[1].longValue();
        bigIntegerArray = bigInteger7.divideAndRemainder(bigInteger);
        LongCarryCRT.M12[0] = bigIntegerArray[0].longValue();
        LongCarryCRT.M12[1] = bigIntegerArray[1].longValue();
        bigIntegerArray = bigInteger2.multiply(bigInteger7).divideAndRemainder(bigInteger);
        LongCarryCRT.M012[2] = bigIntegerArray[1].longValue();
        bigIntegerArray = bigIntegerArray[0].divideAndRemainder(bigInteger);
        LongCarryCRT.M012[0] = bigIntegerArray[0].longValue();
        LongCarryCRT.M012[1] = bigIntegerArray[1].longValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CarryCRTRunnable
    implements Runnable {
        private DataStorage resultMod0;
        private DataStorage resultMod1;
        private DataStorage resultMod2;
        private DataStorage dataStorage;
        private long size;
        private long resultSize;
        private long offset;
        private long length;
        private MessagePasser<Long, long[]> messagePasser;

        public CarryCRTRunnable(DataStorage dataStorage, DataStorage dataStorage2, DataStorage dataStorage3, DataStorage dataStorage4, long l, long l2, long l3, long l4, MessagePasser<Long, long[]> messagePasser) {
            this.resultMod0 = dataStorage;
            this.resultMod1 = dataStorage2;
            this.resultMod2 = dataStorage3;
            this.dataStorage = dataStorage4;
            this.size = l;
            this.resultSize = l2;
            this.offset = l3;
            this.length = l4;
            this.messagePasser = messagePasser;
        }

        @Override
        public void run() {
            long l;
            long l2;
            long l3 = this.offset == 0L ? this.size - this.resultSize + 1L : 0L;
            long l4 = this.offset + this.length == this.size ? 1 : 0;
            long l5 = 1L - l4;
            long l6 = this.length - l3 + l4;
            long l7 = this.size - this.offset;
            long l8 = l7 - this.length;
            long l9 = this.size - this.offset - this.length + l5 + l6;
            long l10 = l9 - l6;
            DataStorage.Iterator iterator = this.resultMod0.iterator(1, l7, l8);
            DataStorage.Iterator iterator2 = this.resultMod1.iterator(1, l7, l8);
            DataStorage.Iterator iterator3 = this.resultMod2.iterator(1, l7, l8);
            DataStorage.Iterator iterator4 = this.dataStorage.iterator(2, l9, l10);
            long[] lArray = new long[3];
            long[] lArray2 = new long[3];
            long[] lArray3 = new long[3];
            for (l2 = 0L; l2 < this.length; ++l2) {
                l = MATH_MOD_0.modMultiply(T0, iterator.getLong());
                long l11 = MATH_MOD_1.modMultiply(T1, iterator2.getLong());
                long l12 = MATH_MOD_2.modMultiply(T2, iterator3.getLong());
                LongCarryCRT.this.multiply(M12, l, lArray2);
                LongCarryCRT.this.multiply(M02, l11, lArray3);
                if (LongCarryCRT.this.add(lArray3, lArray2) != 0L || LongCarryCRT.this.compare(lArray2, M012) >= 0L) {
                    LongCarryCRT.this.subtract(M012, lArray2);
                }
                LongCarryCRT.this.multiply(M01, l12, lArray3);
                if (LongCarryCRT.this.add(lArray3, lArray2) != 0L || LongCarryCRT.this.compare(lArray2, M012) >= 0L) {
                    LongCarryCRT.this.subtract(M012, lArray2);
                }
                LongCarryCRT.this.add(lArray2, lArray);
                long l13 = LongCarryCRT.this.divide(lArray);
                if (l2 >= l3) {
                    iterator4.setLong(l13);
                    iterator4.next();
                }
                iterator.next();
                iterator2.next();
                iterator3.next();
            }
            l2 = LongCarryCRT.this.divide(lArray);
            l = lArray[2];
            assert (lArray[0] == 0L);
            assert (lArray[1] == 0L);
            if (l6 == this.length - l3 + 1L) {
                iterator4.setLong(l2);
                iterator4.close();
                l2 = l;
                assert (l == 0L);
            }
            long[] lArray4 = new long[]{l, l2};
            if (this.offset > 0L) {
                long[] lArray5 = this.messagePasser.receiveMessage(this.offset);
                DataStorage.Iterator iterator5 = LongCarryCRT.arrayIterator(lArray5);
                iterator4 = LongCarryCRT.compositeIterator(this.dataStorage.iterator(3, l9, l10), l6, LongCarryCRT.arrayIterator(lArray4));
                long l14 = LongCarryCRT.this.baseAdd(iterator4, iterator5, 0L, iterator4, lArray5.length);
                l14 = this.baseCarry(iterator4, l14, l6);
                iterator4.close();
                assert (l14 == 0L);
            }
            this.messagePasser.sendMessage(this.offset + this.length, lArray4);
        }

        private long baseCarry(DataStorage.Iterator iterator, long l, long l2) {
            for (long i = 0L; i < l2 && l > 0L; ++i) {
                l = LongCarryCRT.this.baseAdd(iterator, null, l, iterator, 1L);
            }
            return l;
        }
    }
}

