/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.internal.LongBaseMath;
import org.apfloat.internal.LongRadixConstants;

public class LongCRTMath
extends LongBaseMath {
    private static final long serialVersionUID = 7400961005627736773L;
    private static final long BASE_MASK = 0x1FFFFFFFFFFFFFFL;
    private static final double INVERSE_MAX_POWER_OF_TWO_BASE = 6.938893903907228E-18;
    private long base;
    private double inverseBase;

    public LongCRTMath(int n) {
        super(n);
        this.base = LongRadixConstants.BASE[n];
        this.inverseBase = 1.0 / (double)LongRadixConstants.BASE[n];
    }

    public final void multiply(long[] lArray, long l, long[] lArray2) {
        long l2 = lArray[1] * l;
        long l3 = (long)((double)lArray[1] * (double)l * 6.938893903907228E-18);
        l3 += l2 - (l3 << 57) >> 57;
        lArray2[2] = l2 & 0x1FFFFFFFFFFFFFFL;
        l2 = lArray[0] * l + l3;
        l3 = (long)(((double)lArray[0] * (double)l + (double)l3) * 6.938893903907228E-18);
        l3 += l2 - (l3 << 57) >> 57;
        lArray2[1] = l2 & 0x1FFFFFFFFFFFFFFL;
        lArray2[0] = l3;
    }

    public final long compare(long[] lArray, long[] lArray2) {
        long l = lArray[0] - lArray2[0];
        if (l != 0L) {
            return l;
        }
        l = lArray[1] - lArray2[1];
        if (l != 0L) {
            return l;
        }
        return lArray[2] - lArray2[2];
    }

    public final long add(long[] lArray, long[] lArray2) {
        long l = lArray2[2] + lArray[2];
        long l2 = l >= 0x200000000000000L ? 1 : 0;
        lArray2[2] = l = l >= 0x200000000000000L ? l - 0x200000000000000L : l;
        l = lArray2[1] + lArray[1] + l2;
        l2 = l >= 0x200000000000000L ? 1 : 0;
        lArray2[1] = l = l >= 0x200000000000000L ? l - 0x200000000000000L : l;
        l = lArray2[0] + lArray[0] + l2;
        l2 = l >= 0x200000000000000L ? 1 : 0;
        lArray2[0] = l = l >= 0x200000000000000L ? l - 0x200000000000000L : l;
        return l2;
    }

    public final void subtract(long[] lArray, long[] lArray2) {
        long l = lArray2[2] - lArray[2];
        long l2 = l < 0L ? 1 : 0;
        lArray2[2] = l = l < 0L ? l + 0x200000000000000L : l;
        l = lArray2[1] - lArray[1] - l2;
        l2 = l < 0L ? 1 : 0;
        lArray2[1] = l = l < 0L ? l + 0x200000000000000L : l;
        l = lArray2[0] - lArray[0] - l2;
        lArray2[0] = l = l < 0L ? l + 0x200000000000000L : l;
    }

    public final long divide(long[] lArray) {
        long l = (lArray[0] << 57) + lArray[1];
        long l2 = (long)(((double)lArray[0] * 1.4411518807585587E17 + (double)lArray[1]) * this.inverseBase);
        long l3 = l - l2 * this.base;
        int n = (int)((double)l3 * this.inverseBase);
        l2 += (long)n;
        if ((l3 -= (long)n * this.base) >= this.base) {
            l3 -= this.base;
            ++l2;
        }
        if (l3 >= this.base) {
            l3 -= this.base;
            ++l2;
        }
        if (l3 < 0L) {
            l3 += this.base;
            --l2;
        }
        if (l3 < 0L) {
            l3 += this.base;
        }
        lArray[0] = 0L;
        lArray[1] = --l2;
        l = (l3 << 57) + lArray[2];
        l2 = (long)(((double)l3 * 1.4411518807585587E17 + (double)lArray[2]) * this.inverseBase);
        l3 = l - l2 * this.base;
        n = (int)((double)l3 * this.inverseBase);
        l2 += (long)n;
        if ((l3 -= (long)n * this.base) >= this.base) {
            l3 -= this.base;
            ++l2;
        }
        if (l3 >= this.base) {
            l3 -= this.base;
            ++l2;
        }
        if (l3 < 0L) {
            l3 += this.base;
            --l2;
        }
        if (l3 < 0L) {
            l3 += this.base;
        }
        lArray[2] = --l2;
        return l3;
    }
}

