/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.io.Serializable;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.LongRadixConstants;
import org.apfloat.spi.DataStorage;

public class LongBaseMath
implements Serializable {
    private static final long serialVersionUID = -6469225916787810664L;
    private int radix;
    private double inverseBase;

    public LongBaseMath(int n) {
        this.radix = n;
        this.inverseBase = 1.0 / (double)LongRadixConstants.BASE[n];
    }

    public long baseAdd(DataStorage.Iterator iterator, DataStorage.Iterator iterator2, long l, DataStorage.Iterator iterator3, long l2) throws ApfloatRuntimeException {
        assert (iterator == null || iterator != iterator2);
        boolean bl = iterator == iterator3 || iterator2 == iterator3;
        long l3 = LongRadixConstants.BASE[this.radix];
        for (long i = 0L; i < l2; ++i) {
            long l4 = (iterator == null ? 0L : iterator.getLong()) + l + (iterator2 == null ? 0L : iterator2.getLong());
            if (l4 >= l3) {
                l4 -= l3;
                l = 1L;
            } else {
                l = 0L;
            }
            iterator3.setLong(l4);
            if (iterator != null) {
                iterator.next();
            }
            if (iterator2 != null) {
                iterator2.next();
            }
            if (bl) continue;
            iterator3.next();
        }
        return l;
    }

    public long baseSubtract(DataStorage.Iterator iterator, DataStorage.Iterator iterator2, long l, DataStorage.Iterator iterator3, long l2) throws ApfloatRuntimeException {
        assert (iterator == null || iterator != iterator2);
        assert (iterator2 != iterator3);
        long l3 = LongRadixConstants.BASE[this.radix];
        for (long i = 0L; i < l2; ++i) {
            long l4 = (iterator == null ? 0L : iterator.getLong()) - l - (iterator2 == null ? 0L : iterator2.getLong());
            if (l4 < 0L) {
                l4 += l3;
                l = 1L;
            } else {
                l = 0L;
            }
            iterator3.setLong(l4);
            if (iterator != null && iterator != iterator3) {
                iterator.next();
            }
            if (iterator2 != null) {
                iterator2.next();
            }
            iterator3.next();
        }
        return l;
    }

    public long baseMultiplyAdd(DataStorage.Iterator iterator, DataStorage.Iterator iterator2, long l, long l2, DataStorage.Iterator iterator3, long l3) throws ApfloatRuntimeException {
        assert (iterator != iterator2);
        assert (iterator != iterator3);
        long l4 = LongRadixConstants.BASE[this.radix];
        for (long i = 0L; i < l3; ++i) {
            long l5 = iterator.getLong();
            long l6 = l;
            long l7 = l5 * l6 + (l2 += iterator2 == null ? 0L : iterator2.getLong());
            l2 = (long)(((double)l5 * (double)l6 + (double)l2) * this.inverseBase);
            int n = (int)((double)(l7 -= l2 * l4) * this.inverseBase);
            l2 += (long)n;
            if ((l7 -= (long)n * l4) >= l4) {
                l7 -= l4;
                ++l2;
            }
            if (l7 >= l4) {
                l7 -= l4;
                ++l2;
            }
            if (l7 < 0L) {
                l7 += l4;
                --l2;
            }
            if (l7 < 0L) {
                l7 += l4;
                --l2;
            }
            iterator3.setLong(l7);
            iterator.next();
            if (iterator2 != null && iterator2 != iterator3) {
                iterator2.next();
            }
            iterator3.next();
        }
        return l2;
    }

    public long baseDivide(DataStorage.Iterator iterator, long l, long l2, DataStorage.Iterator iterator2, long l3) throws ApfloatRuntimeException {
        assert (iterator != iterator2);
        long l4 = LongRadixConstants.BASE[this.radix];
        double d = 1.0 / (double)l;
        for (long i = 0L; i < l3; ++i) {
            long l5 = iterator == null ? 0L : iterator.getLong();
            long l6 = l2 * l4 + l5;
            long l7 = (long)(((double)l2 * (double)l4 + (double)l5) * d);
            l2 = l6 - l7 * l;
            int n = (int)((double)l2 * d);
            l7 += (long)n;
            if ((l2 -= (long)n * l) >= l) {
                l2 -= l;
                ++l7;
            }
            if (l2 >= l) {
                l2 -= l;
                ++l7;
            }
            if (l2 < 0L) {
                l2 += l;
                --l7;
            }
            if (l2 < 0L) {
                l2 += l;
                --l7;
            }
            iterator2.setLong(l7);
            if (iterator != null) {
                iterator.next();
            }
            iterator2.next();
        }
        return l2;
    }
}

