/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.IntModConstants;
import org.apfloat.internal.IntParallelFNTStrategy;
import org.apfloat.internal.Scramble;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.Util;

public class IntTwoPassFNTStrategy
extends IntParallelFNTStrategy {
    public void transform(DataStorage dataStorage, int n) throws ApfloatRuntimeException {
        ArrayAccess arrayAccess;
        int n2;
        long l = dataStorage.getSize();
        if (l > 0x3000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + l + " > " + 0x3000000L);
        }
        if (l < 2L) {
            return;
        }
        assert (l == (l & -l));
        int n3 = Util.log2down(l);
        int n4 = n3 >> 1;
        int n5 = n3 - n4;
        n4 = 1 << n4;
        n5 = 1 << n5;
        this.setModulus(IntModConstants.MODULUS[n]);
        int n6 = this.getForwardNthRoot(IntModConstants.PRIMITIVE_ROOT[n], l);
        int n7 = this.modPow(n6, n5);
        int[] nArray = this.createWTable(n7, n4);
        int[] nArray2 = Scramble.createScrambleTable(n4);
        int n8 = this.getMaxMemoryBlockSize(l);
        if (n4 > n8 || n5 > n8) {
            throw new ApfloatInternalException("Not enough memory available to fit one row or column of matrix to memory; n1=" + n4 + ", n2=" + n5 + ", available=" + n8);
        }
        int n9 = n8 / n4;
        for (n2 = 0; n2 < n5; n2 += n9) {
            arrayAccess = dataStorage.getTransposedArray(3, n2, n9, n4);
            this.transformRows(n4, n9, false, arrayAccess, nArray, nArray2);
            arrayAccess.close();
        }
        if (n4 != n5) {
            n2 = this.modPow(n6, n4);
            nArray = this.createWTable(n2, n5);
        }
        n9 = n8 / n5;
        for (n2 = 0; n2 < n4; n2 += n9) {
            arrayAccess = dataStorage.getArray(3, n2 * n5, n9 * n5);
            this.multiplyElements(arrayAccess, n2, n9, n5, n6, 1);
            this.transformRows(n5, n9, false, arrayAccess, nArray, null);
            arrayAccess.close();
        }
    }

    public void inverseTransform(DataStorage dataStorage, int n, long l) throws ApfloatRuntimeException {
        ArrayAccess arrayAccess;
        int n2;
        long l2 = dataStorage.getSize();
        if (Math.max(l2, l) > 0x3000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(l2, l) + " > " + 0x3000000L);
        }
        if (l2 < 2L) {
            return;
        }
        assert (l2 == (l2 & -l2));
        int n3 = Util.log2down(l2);
        int n4 = n3 >> 1;
        int n5 = n3 - n4;
        n4 = 1 << n4;
        n5 = 1 << n5;
        this.setModulus(IntModConstants.MODULUS[n]);
        int n6 = this.getInverseNthRoot(IntModConstants.PRIMITIVE_ROOT[n], l2);
        int n7 = this.modPow(n6, n4);
        int n8 = this.modDivide(1, (int)l);
        int[] nArray = this.createWTable(n7, n5);
        int[] nArray2 = Scramble.createScrambleTable(n4);
        int n9 = this.getMaxMemoryBlockSize(l2);
        if (n4 > n9 || n5 > n9) {
            throw new ApfloatInternalException("Not enough memory available to fit one row or column of matrix to memory; n1=" + n4 + ", n2=" + n5 + ", available=" + n9);
        }
        int n10 = n9 / n5;
        for (n2 = 0; n2 < n4; n2 += n10) {
            arrayAccess = dataStorage.getArray(3, n2 * n5, n10 * n5);
            this.transformRows(n5, n10, true, arrayAccess, nArray, null);
            this.multiplyElements(arrayAccess, n2, n10, n5, n6, n8);
            arrayAccess.close();
        }
        if (n4 != n5) {
            for (n2 = 1; n2 < n4; ++n2) {
                nArray[n2] = nArray[2 * n2];
            }
        }
        n10 = n9 / n4;
        for (n2 = 0; n2 < n5; n2 += n10) {
            arrayAccess = dataStorage.getTransposedArray(3, n2, n10, n4);
            this.transformRows(n4, n10, true, arrayAccess, nArray, nArray2);
            arrayAccess.close();
        }
    }

    private int getMaxMemoryBlockSize(long l) {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        long l2 = Util.round2down(Math.min(apfloatContext.getMaxMemoryBlockSize() / 4L, Integer.MAX_VALUE));
        int n = (int)Math.min(l, l2);
        return n;
    }
}

