/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.IntModConstants;
import org.apfloat.internal.IntModMath;
import org.apfloat.internal.IntScramble;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.NTTStrategy;
import org.apfloat.spi.Util;

public class IntTableFNTStrategy
extends IntModMath
implements NTTStrategy {
    public void transform(DataStorage dataStorage, int n) throws ApfloatRuntimeException {
        long l = dataStorage.getSize();
        if (l > 0x3000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + l + " > " + 0x3000000L);
        }
        if (l > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l);
        }
        this.setModulus(IntModConstants.MODULUS[n]);
        int n2 = this.getForwardNthRoot(IntModConstants.PRIMITIVE_ROOT[n], l);
        int[] nArray = this.createWTable(n2, (int)l);
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l);
        this.tableFNT(arrayAccess, nArray, null);
        arrayAccess.close();
    }

    public void inverseTransform(DataStorage dataStorage, int n, long l) throws ApfloatRuntimeException {
        long l2 = dataStorage.getSize();
        if (Math.max(l2, l) > 0x3000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(l2, l) + " > " + 0x3000000L);
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l2);
        }
        this.setModulus(IntModConstants.MODULUS[n]);
        int n2 = this.getInverseNthRoot(IntModConstants.PRIMITIVE_ROOT[n], l2);
        int[] nArray = this.createWTable(n2, (int)l2);
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l2);
        this.inverseTableFNT(arrayAccess, nArray, null);
        this.divideElements(arrayAccess, (int)l);
        arrayAccess.close();
    }

    public long getTransformLength(long l) {
        return Util.round2up(l);
    }

    protected void tableFNT(ArrayAccess arrayAccess, int[] nArray, int[] nArray2) throws ApfloatRuntimeException {
        int[] nArray3 = arrayAccess.getIntData();
        int n = arrayAccess.getOffset();
        int n2 = arrayAccess.getLength();
        assert (n2 == (n2 & -n2));
        if (n2 < 2) {
            return;
        }
        int n3 = 1;
        for (int i = n2 >> 1; i > 0; i >>= 1) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = i << 1;
            for (n7 = n; n7 < n + n2; n7 += n8) {
                n6 = n7 + i;
                n5 = nArray3[n7];
                n4 = nArray3[n6];
                nArray3[n7] = this.modAdd(n5, n4);
                nArray3[n6] = this.modSubtract(n5, n4);
            }
            n7 = n3;
            for (n6 = 1; n6 < i; ++n6) {
                for (n5 = n + n6; n5 < n + n2; n5 += n8) {
                    n4 = n5 + i;
                    int n9 = nArray3[n5];
                    int n10 = nArray3[n4];
                    nArray3[n5] = this.modAdd(n9, n10);
                    nArray3[n4] = this.modMultiply(nArray[n7], this.modSubtract(n9, n10));
                }
                n7 += n3;
            }
            n3 <<= 1;
        }
        if (nArray2 != null) {
            IntScramble.scramble(nArray3, n, nArray2);
        }
    }

    protected void inverseTableFNT(ArrayAccess arrayAccess, int[] nArray, int[] nArray2) throws ApfloatRuntimeException {
        int[] nArray3 = arrayAccess.getIntData();
        int n = arrayAccess.getOffset();
        int n2 = arrayAccess.getLength();
        assert (n2 == (n2 & -n2));
        if (n2 < 2) {
            return;
        }
        if (nArray2 != null) {
            IntScramble.scramble(nArray3, n, nArray2);
        }
        int n3 = n2;
        int n4 = 1;
        while (n2 > n4) {
            int n5;
            int n6;
            int n7;
            int n8 = n4 << 1;
            n3 >>= 1;
            for (n7 = n; n7 < n + n2; n7 += n8) {
                n6 = n7 + n4;
                n5 = nArray3[n6];
                nArray3[n6] = this.modSubtract(nArray3[n7], n5);
                nArray3[n7] = this.modAdd(nArray3[n7], n5);
            }
            n7 = n3;
            for (n6 = 1; n6 < n4; ++n6) {
                for (n5 = n + n6; n5 < n + n2; n5 += n8) {
                    int n9 = n5 + n4;
                    int n10 = this.modMultiply(nArray[n7], nArray3[n9]);
                    nArray3[n9] = this.modSubtract(nArray3[n5], n10);
                    nArray3[n5] = this.modAdd(nArray3[n5], n10);
                }
                n7 += n3;
            }
            n4 = n8;
        }
    }

    private void divideElements(ArrayAccess arrayAccess, int n) throws ApfloatRuntimeException {
        int n2 = this.modDivide(1, n);
        int[] nArray = arrayAccess.getIntData();
        int n3 = arrayAccess.getLength();
        int n4 = arrayAccess.getOffset();
        for (int i = 0; i < n3; ++i) {
            nArray[i + n4] = this.modMultiply(nArray[i + n4], n2);
        }
    }
}

