/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.IntMatrix;
import org.apfloat.internal.IntModConstants;
import org.apfloat.internal.IntParallelFNTStrategy;
import org.apfloat.internal.Scramble;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.Util;

public class IntSixStepFNTStrategy
extends IntParallelFNTStrategy {
    public void transform(DataStorage dataStorage, int n) throws ApfloatRuntimeException {
        long l = dataStorage.getSize();
        if (l > 0x3000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + l + " > " + 0x3000000L);
        }
        if (l > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l);
        }
        if (l < 2L) {
            return;
        }
        assert (l == (l & -l));
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l);
        this.transform(arrayAccess, n);
        arrayAccess.close();
    }

    public void inverseTransform(DataStorage dataStorage, int n, long l) throws ApfloatRuntimeException {
        long l2 = dataStorage.getSize();
        if (Math.max(l2, l) > 0x3000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(l2, l) + " > " + 0x3000000L);
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l2);
        }
        if (l2 < 2L) {
            return;
        }
        assert (l2 == (l2 & -l2));
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l2);
        this.inverseTransform(arrayAccess, n, l);
        arrayAccess.close();
    }

    void transform(ArrayAccess arrayAccess, int n) throws ApfloatRuntimeException {
        int n2 = arrayAccess.getLength();
        if (n2 < 2) {
            return;
        }
        assert (n2 == (n2 & -n2));
        int n3 = Util.log2down(n2);
        int n4 = n3 >> 1;
        int n5 = n3 - n4;
        n4 = 1 << n4;
        n5 = 1 << n5;
        this.setModulus(IntModConstants.MODULUS[n]);
        int n6 = this.getForwardNthRoot(IntModConstants.PRIMITIVE_ROOT[n], n2);
        int n7 = this.modPow(n6, n5);
        int[] nArray = this.createWTable(n7, n4);
        int[] nArray2 = Scramble.createScrambleTable(n4);
        IntMatrix.transpose(arrayAccess, n4, n5);
        this.transformRows(n4, n5, false, arrayAccess, nArray, nArray2);
        IntMatrix.transpose(arrayAccess, n5, n4);
        this.multiplyElements(arrayAccess, 0, n4, n5, n6, 1);
        if (n4 != n5) {
            int n8 = this.modPow(n6, n4);
            nArray = this.createWTable(n8, n5);
        }
        this.transformRows(n5, n4, false, arrayAccess, nArray, null);
    }

    void inverseTransform(ArrayAccess arrayAccess, int n, long l) throws ApfloatRuntimeException {
        int n2 = arrayAccess.getLength();
        if (n2 < 2) {
            return;
        }
        assert (n2 == (n2 & -n2));
        int n3 = Util.log2down(n2);
        int n4 = n3 >> 1;
        int n5 = n3 - n4;
        n4 = 1 << n4;
        n5 = 1 << n5;
        this.setModulus(IntModConstants.MODULUS[n]);
        int n6 = this.getInverseNthRoot(IntModConstants.PRIMITIVE_ROOT[n], n2);
        int n7 = this.modPow(n6, n4);
        int n8 = this.modDivide(1, (int)l);
        int[] nArray = this.createWTable(n7, n5);
        int[] nArray2 = Scramble.createScrambleTable(n4);
        this.transformRows(n5, n4, true, arrayAccess, nArray, null);
        this.multiplyElements(arrayAccess, 0, n4, n5, n6, n8);
        IntMatrix.transpose(arrayAccess, n4, n5);
        if (n4 != n5) {
            for (int i = 1; i < n4; ++i) {
                nArray[i] = nArray[2 * i];
            }
        }
        this.transformRows(n4, n5, true, arrayAccess, nArray, nArray2);
        IntMatrix.transpose(arrayAccess, n5, n4);
    }
}

