/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.IntTableFNTStrategy;
import org.apfloat.internal.ParallelNTTStrategy;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.spi.ArrayAccess;

public abstract class IntParallelFNTStrategy
extends IntTableFNTStrategy
implements ParallelNTTStrategy {
    protected ParallelRunner parallelRunner;

    protected IntParallelFNTStrategy() {
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        this.parallelRunner = parallelRunner;
    }

    protected void multiplyElements(final ArrayAccess arrayAccess, final int n, final int n2, final int n3, final int n4, final int n5) throws ApfloatRuntimeException {
        ParallelRunnable parallelRunnable = new ParallelRunnable(){

            public int getLength() {
                return n2;
            }

            public Runnable getRunnable(int n6, int n22) {
                ArrayAccess arrayAccess2 = arrayAccess.subsequence(n6 * n3, n22 * n3);
                return new MultiplyRunnable(arrayAccess2, n + n6, n22, n3, n4, n5);
            }
        };
        this.parallelRunner.runParallel(parallelRunnable);
    }

    protected void transformRows(final int n, final int n2, final boolean bl, final ArrayAccess arrayAccess, final int[] nArray, final int[] nArray2) throws ApfloatRuntimeException {
        ParallelRunnable parallelRunnable = new ParallelRunnable(){

            public int getLength() {
                return n2;
            }

            public Runnable getRunnable(int n3, int n22) {
                ArrayAccess arrayAccess2 = arrayAccess.subsequence(n3 * n, n22 * n);
                return new TableFNTRunnable(n, bl, arrayAccess2, nArray, nArray2);
            }
        };
        this.parallelRunner.runParallel(parallelRunnable);
    }

    private class MultiplyRunnable
    implements Runnable {
        private ArrayAccess arrayAccess;
        private int startRow;
        private int rows;
        private int columns;
        private int w;
        private int scaleFactor;

        public MultiplyRunnable(ArrayAccess arrayAccess, int n, int n2, int n3, int n4, int n5) {
            this.arrayAccess = arrayAccess;
            this.startRow = n;
            this.rows = n2;
            this.columns = n3;
            this.w = n4;
            this.scaleFactor = n5;
        }

        public void run() {
            int[] nArray = this.arrayAccess.getIntData();
            int n = this.arrayAccess.getOffset();
            int n2 = IntParallelFNTStrategy.this.modPow(this.w, this.startRow);
            for (int i = 0; i < this.rows; ++i) {
                int n3 = this.scaleFactor;
                int n4 = 0;
                while (n4 < this.columns) {
                    nArray[n] = IntParallelFNTStrategy.this.modMultiply(nArray[n], n3);
                    n3 = IntParallelFNTStrategy.this.modMultiply(n3, n2);
                    ++n4;
                    ++n;
                }
                n2 = IntParallelFNTStrategy.this.modMultiply(n2, this.w);
            }
        }
    }

    private class TableFNTRunnable
    implements Runnable {
        private int length;
        private boolean isInverse;
        private ArrayAccess arrayAccess;
        private int[] wTable;
        private int[] permutationTable;

        public TableFNTRunnable(int n, boolean bl, ArrayAccess arrayAccess, int[] nArray, int[] nArray2) {
            this.length = n;
            this.isInverse = bl;
            this.arrayAccess = arrayAccess;
            this.wTable = nArray;
            this.permutationTable = nArray2;
        }

        public void run() {
            int n = this.arrayAccess.getLength();
            for (int i = 0; i < n; i += this.length) {
                ArrayAccess arrayAccess = this.arrayAccess.subsequence(i, this.length);
                if (this.isInverse) {
                    IntParallelFNTStrategy.this.inverseTableFNT(arrayAccess, this.wTable, this.permutationTable);
                    continue;
                }
                IntParallelFNTStrategy.this.tableFNT(arrayAccess, this.wTable, this.permutationTable);
            }
        }
    }
}

