/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.Util;

public class IntMatrix {
    private IntMatrix() {
    }

    public static void transpose(ArrayAccess arrayAccess, int n, int n2) throws ApfloatRuntimeException {
        int[] nArray = arrayAccess.getIntData();
        int n3 = arrayAccess.getOffset();
        if (n != (n & -n) || n2 != (n2 & -n2) || n <= 0 || n2 <= 0) {
            throw new ApfloatInternalException("Matrix size must be a power of two, not " + n + " x " + n2);
        }
        if (n == n2) {
            IntMatrix.transposeSquare(nArray, n3, n, n);
        } else if (n2 == 2 * n) {
            IntMatrix.transposeSquare(nArray, n3, n, n2);
            IntMatrix.transposeSquare(nArray, n3 + n, n, n2);
            IntMatrix.permuteWideToTall(nArray, n3, n, n2);
        } else if (n == 2 * n2) {
            IntMatrix.permuteTallToWide(nArray, n3, n, n2);
            IntMatrix.transposeSquare(nArray, n3, n2, n);
            IntMatrix.transposeSquare(nArray, n3 + n2, n2, n);
        } else {
            throw new ApfloatInternalException("Must be n1 = n2, n1 = 2*n2 or n2 = 2*n1; matrix is " + n + " x " + n2);
        }
    }

    public static void transposeSquare(ArrayAccess arrayAccess, int n, int n2) throws ApfloatRuntimeException {
        IntMatrix.transposeSquare(arrayAccess.getIntData(), arrayAccess.getOffset(), n, n2);
    }

    private static void moveBlock(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4, int n5) {
        for (int i = 0; i < n5; ++i) {
            System.arraycopy(nArray, n, nArray2, n3, n5);
            n3 += n4;
            n += n2;
        }
    }

    private static void transpose2blocks(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n2;
        while (n5 < n4) {
            int n7 = 0;
            int n8 = n + n5;
            while (n7 < n4) {
                int n9 = nArray[n6 + n7];
                nArray[n6 + n7] = nArray[n8];
                nArray[n8] = n9;
                ++n7;
                n8 += n3;
            }
            ++n5;
            n6 += n3;
        }
    }

    private static void transposeBlock(int[] nArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n;
        while (n4 < n3) {
            int n6 = n4 + 1;
            int n7 = n + n6 * n2 + n4;
            while (n6 < n3) {
                int n8 = nArray[n5 + n6];
                nArray[n5 + n6] = nArray[n7];
                nArray[n7] = n8;
                ++n6;
                n7 += n2;
            }
            ++n4;
            n5 += n2;
        }
    }

    private static void transposeSquare(int[] nArray, int n, int n2, int n3) {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        int n4 = Util.round2down(apfloatContext.getCacheBurst() / 4);
        int n5 = Util.sqrt4down(apfloatContext.getCacheL1Size() / 4);
        int n6 = Util.round2down(apfloatContext.getCacheL2Size() / 4);
        if (n2 <= n4 || n2 <= n5) {
            IntMatrix.transposeBlock(nArray, n, n3, n2);
        } else if (n2 * n3 <= n6) {
            int n7 = n4;
            int n8 = 0;
            int n9 = n;
            while (n8 < n2) {
                IntMatrix.transposeBlock(nArray, n9 + n8, n3, n7);
                int n10 = n8 + n7;
                int n11 = n + n10 * n3 + n8;
                while (n10 < n2) {
                    IntMatrix.transpose2blocks(nArray, n9 + n10, n11, n3, n7);
                    n10 += n7;
                    n11 += n7 * n3;
                }
                n8 += n7;
                n9 += n7 * n3;
            }
        } else {
            int n12 = n5;
            int[] nArray2 = new int[n12 * n12];
            int[] nArray3 = new int[n12 * n12];
            int n13 = 0;
            int n14 = n;
            while (n13 < n2) {
                IntMatrix.moveBlock(nArray, n14 + n13, n3, nArray2, 0, n12, n12);
                IntMatrix.transposeBlock(nArray2, 0, n12, n12);
                IntMatrix.moveBlock(nArray2, 0, n12, nArray, n14 + n13, n3, n12);
                int n15 = n13 + n12;
                int n16 = n + n15 * n3 + n13;
                while (n15 < n2) {
                    IntMatrix.moveBlock(nArray, n14 + n15, n3, nArray2, 0, n12, n12);
                    IntMatrix.transposeBlock(nArray2, 0, n12, n12);
                    IntMatrix.moveBlock(nArray, n16, n3, nArray3, 0, n12, n12);
                    IntMatrix.transposeBlock(nArray3, 0, n12, n12);
                    IntMatrix.moveBlock(nArray3, 0, n12, nArray, n14 + n15, n3, n12);
                    IntMatrix.moveBlock(nArray2, 0, n12, nArray, n16, n3, n12);
                    n15 += n12;
                    n16 += n12 * n3;
                }
                n13 += n12;
                n14 += n12 * n3;
            }
        }
    }

    private static void permuteWideToTall(int[] nArray, int n, int n2, int n3) {
        assert (n3 == 2 * n2);
        if (n3 < 4) {
            return;
        }
        int[] nArray2 = new int[n2];
        boolean[] blArray = new boolean[n3];
        int n4 = 1;
        do {
            int n5 = n4;
            int n6 = n4;
            System.arraycopy(nArray, n + n2 * n6, nArray2, 0, n2);
            blArray[n6] = true;
            int n7 = n6 = n6 < n2 ? 2 * n6 : 2 * (n6 - n2) + 1;
            while (n6 != n4) {
                blArray[n6] = true;
                System.arraycopy(nArray, n + n2 * n6, nArray, n + n2 * n5, n2);
                n5 = n6;
                n6 = n6 < n2 ? 2 * n6 : 2 * (n6 - n2) + 1;
            }
            System.arraycopy(nArray2, 0, nArray, n + n2 * n5, n2);
            while (blArray[n4]) {
                ++n4;
            }
        } while (n4 < n3 - 1);
    }

    private static void permuteTallToWide(int[] nArray, int n, int n2, int n3) {
        assert (n2 == 2 * n3);
        if (n2 < 4) {
            return;
        }
        int[] nArray2 = new int[n3];
        boolean[] blArray = new boolean[n2];
        int n4 = 1;
        do {
            int n5 = n4;
            int n6 = n4;
            System.arraycopy(nArray, n + n3 * n6, nArray2, 0, n3);
            blArray[n6] = true;
            int n7 = n6 = (n6 & 1) != 0 ? n6 / 2 + n3 : n6 / 2;
            while (n6 != n4) {
                blArray[n6] = true;
                System.arraycopy(nArray, n + n3 * n6, nArray, n + n3 * n5, n3);
                n5 = n6;
                n6 = (n6 & 1) != 0 ? n6 / 2 + n3 : n6 / 2;
            }
            System.arraycopy(nArray2, 0, nArray, n + n3 * n5, n3);
            while (blArray[n4]) {
                ++n4;
            }
        } while (n4 < n2 - 1);
    }
}

