/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.IntModConstants;
import org.apfloat.internal.IntParallelFNTStrategy;
import org.apfloat.internal.IntSixStepFNTStrategy;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.Util;

public class IntFactor3SixStepNTTStrategy
extends IntParallelFNTStrategy {
    private IntSixStepFNTStrategy factor2Strategy;

    public IntFactor3SixStepNTTStrategy(IntSixStepFNTStrategy intSixStepFNTStrategy) {
        this.factor2Strategy = intSixStepFNTStrategy;
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        super.setParallelRunner(parallelRunner);
        this.factor2Strategy.setParallelRunner(parallelRunner);
    }

    public void transform(DataStorage dataStorage, int n) throws ApfloatRuntimeException {
        long l = dataStorage.getSize();
        if (l > 0x3000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + l + " > " + 0x3000000L);
        }
        if (l > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l);
        }
        int n2 = (int)(l & -l);
        if (l == (long)n2) {
            this.factor2Strategy.transform(dataStorage, n);
        } else {
            assert (l == (long)(3 * n2));
            this.setModulus(IntModConstants.MODULUS[n]);
            int n3 = this.getForwardNthRoot(IntModConstants.PRIMITIVE_ROOT[n], l);
            int n4 = this.modPow(n3, n2);
            ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l);
            ArrayAccess arrayAccess2 = arrayAccess.subsequence(0, n2);
            ArrayAccess arrayAccess3 = arrayAccess.subsequence(n2, n2);
            ArrayAccess arrayAccess4 = arrayAccess.subsequence(2 * n2, n2);
            this.transformColumns(false, arrayAccess2, arrayAccess3, arrayAccess4, n2, n3, n4);
            this.factor2Strategy.transform(arrayAccess2, n);
            this.factor2Strategy.transform(arrayAccess3, n);
            this.factor2Strategy.transform(arrayAccess4, n);
            arrayAccess.close();
        }
    }

    public void inverseTransform(DataStorage dataStorage, int n, long l) throws ApfloatRuntimeException {
        long l2 = dataStorage.getSize();
        if (Math.max(l2, l) > 0x3000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(l2, l) + " > " + 0x3000000L);
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l2);
        }
        int n2 = (int)(l2 & -l2);
        if (l2 == (long)n2) {
            this.factor2Strategy.inverseTransform(dataStorage, n, l);
        } else {
            assert (l2 == (long)(3 * n2));
            this.setModulus(IntModConstants.MODULUS[n]);
            int n3 = this.getInverseNthRoot(IntModConstants.PRIMITIVE_ROOT[n], l2);
            int n4 = this.modPow(n3, n2);
            ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l2);
            ArrayAccess arrayAccess2 = arrayAccess.subsequence(0, n2);
            ArrayAccess arrayAccess3 = arrayAccess.subsequence(n2, n2);
            ArrayAccess arrayAccess4 = arrayAccess.subsequence(2 * n2, n2);
            this.factor2Strategy.inverseTransform(arrayAccess2, n, l);
            this.factor2Strategy.inverseTransform(arrayAccess3, n, l);
            this.factor2Strategy.inverseTransform(arrayAccess4, n, l);
            this.transformColumns(true, arrayAccess2, arrayAccess3, arrayAccess4, n2, n3, n4);
            arrayAccess.close();
        }
    }

    public long getTransformLength(long l) {
        return Util.round23up(l);
    }

    private void transformColumns(final boolean bl, final ArrayAccess arrayAccess, final ArrayAccess arrayAccess2, final ArrayAccess arrayAccess3, final int n, final int n2, int n3) throws ApfloatRuntimeException {
        final int n4 = this.modMultiply(n2, n2);
        final int n5 = this.negate(this.modDivide(3, 2));
        final int n6 = this.modAdd(n3, this.modDivide(1, 2));
        ParallelRunnable parallelRunnable = new ParallelRunnable(){

            public int getLength() {
                return n;
            }

            public Runnable getRunnable(int n3, int n22) {
                return new ColumnTransformRunnable(bl, arrayAccess, arrayAccess2, arrayAccess3, n3, n22, n2, n4, n5, n6);
            }
        };
        this.parallelRunner.runParallel(parallelRunnable);
    }

    private class ColumnTransformRunnable
    implements Runnable {
        private boolean isInverse;
        private ArrayAccess arrayAccess0;
        private ArrayAccess arrayAccess1;
        private ArrayAccess arrayAccess2;
        private int startColumn;
        private int columns;
        private int w;
        private int ww;
        private int w1;
        private int w2;

        public ColumnTransformRunnable(boolean bl, ArrayAccess arrayAccess, ArrayAccess arrayAccess2, ArrayAccess arrayAccess3, int n, int n2, int n3, int n4, int n5, int n6) {
            this.isInverse = bl;
            this.arrayAccess0 = arrayAccess;
            this.arrayAccess1 = arrayAccess2;
            this.arrayAccess2 = arrayAccess3;
            this.startColumn = n;
            this.columns = n2;
            this.w = n3;
            this.ww = n4;
            this.w1 = n5;
            this.w2 = n6;
        }

        public void run() {
            int n = IntFactor3SixStepNTTStrategy.this.modPow(this.w, this.startColumn);
            int n2 = IntFactor3SixStepNTTStrategy.this.modPow(this.ww, this.startColumn);
            int[] nArray = this.arrayAccess0.getIntData();
            int[] nArray2 = this.arrayAccess1.getIntData();
            int[] nArray3 = this.arrayAccess2.getIntData();
            int n3 = this.arrayAccess0.getOffset() + this.startColumn;
            int n4 = this.arrayAccess1.getOffset() + this.startColumn;
            int n5 = this.arrayAccess2.getOffset() + this.startColumn;
            for (int i = 0; i < this.columns; ++i) {
                int n6 = nArray[n3 + i];
                int n7 = nArray2[n4 + i];
                int n8 = nArray3[n5 + i];
                if (this.isInverse) {
                    n7 = IntFactor3SixStepNTTStrategy.this.modMultiply(n7, n);
                    n8 = IntFactor3SixStepNTTStrategy.this.modMultiply(n8, n2);
                }
                int n9 = IntFactor3SixStepNTTStrategy.this.modAdd(n7, n8);
                n8 = IntFactor3SixStepNTTStrategy.this.modSubtract(n7, n8);
                n6 = IntFactor3SixStepNTTStrategy.this.modAdd(n6, n9);
                n9 = IntFactor3SixStepNTTStrategy.this.modMultiply(n9, this.w1);
                n8 = IntFactor3SixStepNTTStrategy.this.modMultiply(n8, this.w2);
                n9 = IntFactor3SixStepNTTStrategy.this.modAdd(n9, n6);
                n7 = IntFactor3SixStepNTTStrategy.this.modAdd(n9, n8);
                n8 = IntFactor3SixStepNTTStrategy.this.modSubtract(n9, n8);
                if (!this.isInverse) {
                    n7 = IntFactor3SixStepNTTStrategy.this.modMultiply(n7, n);
                    n8 = IntFactor3SixStepNTTStrategy.this.modMultiply(n8, n2);
                }
                nArray[n3 + i] = n6;
                nArray2[n4 + i] = n7;
                nArray3[n5 + i] = n8;
                n = IntFactor3SixStepNTTStrategy.this.modMultiply(n, this.w);
                n2 = IntFactor3SixStepNTTStrategy.this.modMultiply(n2, this.ww);
            }
        }
    }
}

