/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.IntModConstants;
import org.apfloat.internal.IntModMath;
import org.apfloat.internal.ParallelNTTStrategy;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.NTTStrategy;
import org.apfloat.spi.Util;

public class IntFactor3NTTStrategy
extends IntModMath
implements ParallelNTTStrategy {
    private NTTStrategy factor2Strategy;

    public IntFactor3NTTStrategy(NTTStrategy nTTStrategy) {
        this.factor2Strategy = nTTStrategy;
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        if (this.factor2Strategy instanceof ParallelNTTStrategy) {
            ((ParallelNTTStrategy)this.factor2Strategy).setParallelRunner(parallelRunner);
        }
    }

    public void transform(DataStorage dataStorage, int n) throws ApfloatRuntimeException {
        long l = dataStorage.getSize();
        long l2 = l & -l;
        if (l > 0x3000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + l + " > " + 0x3000000L);
        }
        if (l == l2) {
            this.factor2Strategy.transform(dataStorage, n);
        } else {
            assert (l == 3L * l2);
            this.setModulus(IntModConstants.MODULUS[n]);
            int n2 = this.getForwardNthRoot(IntModConstants.PRIMITIVE_ROOT[n], l);
            int n3 = this.modPow(n2, (int)l2);
            DataStorage dataStorage2 = dataStorage.subsequence(0L, l2);
            DataStorage dataStorage3 = dataStorage.subsequence(l2, l2);
            DataStorage dataStorage4 = dataStorage.subsequence(2L * l2, l2);
            this.transformColumns(false, dataStorage2, dataStorage3, dataStorage4, l2, n2, n3);
            this.factor2Strategy.transform(dataStorage2, n);
            this.factor2Strategy.transform(dataStorage3, n);
            this.factor2Strategy.transform(dataStorage4, n);
        }
    }

    public void inverseTransform(DataStorage dataStorage, int n, long l) throws ApfloatRuntimeException {
        long l2 = dataStorage.getSize();
        long l3 = l2 & -l2;
        if (Math.max(l2, l) > 0x3000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(l2, l) + " > " + 0x3000000L);
        }
        if (l2 == l3) {
            this.factor2Strategy.inverseTransform(dataStorage, n, l);
        } else {
            assert (l2 == 3L * l3);
            this.setModulus(IntModConstants.MODULUS[n]);
            int n2 = this.getInverseNthRoot(IntModConstants.PRIMITIVE_ROOT[n], l2);
            int n3 = this.modPow(n2, (int)l3);
            DataStorage dataStorage2 = dataStorage.subsequence(0L, l3);
            DataStorage dataStorage3 = dataStorage.subsequence(l3, l3);
            DataStorage dataStorage4 = dataStorage.subsequence(2L * l3, l3);
            this.factor2Strategy.inverseTransform(dataStorage2, n, l);
            this.factor2Strategy.inverseTransform(dataStorage3, n, l);
            this.factor2Strategy.inverseTransform(dataStorage4, n, l);
            this.transformColumns(true, dataStorage2, dataStorage3, dataStorage4, l3, n2, n3);
        }
    }

    public long getTransformLength(long l) {
        return Util.round23up(l);
    }

    private void transformColumns(boolean bl, DataStorage dataStorage, DataStorage dataStorage2, DataStorage dataStorage3, long l, int n, int n2) throws ApfloatRuntimeException {
        DataStorage.Iterator iterator = dataStorage.iterator(3, 0L, l);
        DataStorage.Iterator iterator2 = dataStorage2.iterator(3, 0L, l);
        DataStorage.Iterator iterator3 = dataStorage3.iterator(3, 0L, l);
        int n3 = this.modMultiply(n, n);
        int n4 = this.negate(this.modDivide(3, 2));
        int n5 = this.modAdd(n2, this.modDivide(1, 2));
        int n6 = 1;
        int n7 = 1;
        while (l > 0L) {
            int n8 = iterator.getInt();
            int n9 = iterator2.getInt();
            int n10 = iterator3.getInt();
            if (bl) {
                n9 = this.modMultiply(n9, n6);
                n10 = this.modMultiply(n10, n7);
            }
            int n11 = this.modAdd(n9, n10);
            n10 = this.modSubtract(n9, n10);
            n8 = this.modAdd(n8, n11);
            n11 = this.modMultiply(n11, n4);
            n10 = this.modMultiply(n10, n5);
            n11 = this.modAdd(n11, n8);
            n9 = this.modAdd(n11, n10);
            n10 = this.modSubtract(n11, n10);
            if (!bl) {
                n9 = this.modMultiply(n9, n6);
                n10 = this.modMultiply(n10, n7);
            }
            iterator.setInt(n8);
            iterator2.setInt(n9);
            iterator3.setInt(n10);
            iterator.next();
            iterator2.next();
            iterator3.next();
            n6 = this.modMultiply(n6, n);
            n7 = this.modMultiply(n7, n3);
            --l;
        }
    }
}

