/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.DiskDataStorage;
import org.apfloat.internal.IntMatrix;
import org.apfloat.internal.IntMemoryArrayAccess;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;

public class IntDiskDataStorage
extends DiskDataStorage {
    private static final long serialVersionUID = -1540087135754114721L;

    public IntDiskDataStorage() throws ApfloatRuntimeException {
    }

    protected IntDiskDataStorage(IntDiskDataStorage intDiskDataStorage, long l, long l2) {
        super(intDiskDataStorage, l, l2);
    }

    protected DataStorage implSubsequence(long l, long l2) throws ApfloatRuntimeException {
        return new IntDiskDataStorage(this, l + this.getOffset(), l2);
    }

    protected ArrayAccess implGetArray(int n, long l, int n2) throws ApfloatRuntimeException {
        return new IntDiskArrayAccess(n, this.getOffset() + l, n2);
    }

    protected synchronized ArrayAccess implGetTransposedArray(int n, int n2, int n3, int n4) throws ApfloatRuntimeException {
        TransposedMemoryArrayAccess transposedMemoryArrayAccess;
        block8: {
            int n5 = (int)(this.getSize() / (long)n4);
            if (n3 != (n3 & -n3) || n4 != (n4 & -n4) || n2 + n3 > n5) {
                throw new ApfloatInternalException("Invalid size");
            }
            int n6 = n3 * n4;
            int n7 = Math.min(n3, n4);
            transposedMemoryArrayAccess = new TransposedMemoryArrayAccess(n, new int[n6], n2, n3, n4);
            if ((n & 1) == 0) break block8;
            if (n3 < n4) {
                long l = n2;
                for (int i = 0; i < n4; i += n7) {
                    int n8 = i;
                    for (int j = 0; j < n7; ++j) {
                        this.readToArray(l, transposedMemoryArrayAccess, n8, n7);
                        l += (long)n5;
                        n8 += n4;
                    }
                    ArrayAccess arrayAccess = ((ArrayAccess)transposedMemoryArrayAccess).subsequence(i, n6 - i);
                    IntMatrix.transposeSquare(arrayAccess, n7, n4);
                }
            } else {
                int n9;
                for (n9 = 0; n9 < n7; ++n9) {
                    long l = n2 + n9 * n5;
                    int n10 = n9 * n7;
                    for (int i = 0; i < n3; i += n7) {
                        this.readToArray(l, transposedMemoryArrayAccess, n10, n7);
                        l += (long)n7;
                        n10 += n7 * n7;
                    }
                }
                for (n9 = 0; n9 < n6; n9 += n7 * n7) {
                    ArrayAccess arrayAccess = ((ArrayAccess)transposedMemoryArrayAccess).subsequence(n9, n6 - n9);
                    IntMatrix.transposeSquare(arrayAccess, n7, n7);
                }
            }
        }
        return transposedMemoryArrayAccess;
    }

    private synchronized void setTransposedArray(ArrayAccess arrayAccess, int n, int n2, int n3) throws ApfloatRuntimeException {
        int n4 = (int)(this.getSize() / (long)n3);
        int n5 = arrayAccess.getLength();
        int n6 = Math.min(n2, n3);
        if (n2 < n3) {
            long l = n;
            for (int i = 0; i < n3; i += n6) {
                int n7 = i;
                ArrayAccess arrayAccess2 = arrayAccess.subsequence(i, n5 - i);
                IntMatrix.transposeSquare(arrayAccess2, n6, n3);
                for (int j = 0; j < n6; ++j) {
                    this.writeFromArray(arrayAccess, n7, l, n6);
                    n7 += n3;
                    l += (long)n4;
                }
            }
        } else {
            int n8;
            for (n8 = 0; n8 < n5; n8 += n6 * n6) {
                ArrayAccess arrayAccess3 = arrayAccess.subsequence(n8, n5 - n8);
                IntMatrix.transposeSquare(arrayAccess3, n6, n6);
            }
            for (n8 = 0; n8 < n6; ++n8) {
                long l = n + n8 * n4;
                int n9 = n8 * n6;
                for (int i = 0; i < n2; i += n6) {
                    this.writeFromArray(arrayAccess, n9, l, n6);
                    n9 += n6 * n6;
                    l += (long)n6;
                }
            }
        }
    }

    private void readToArray(long l, ArrayAccess arrayAccess, int n, int n2) throws ApfloatRuntimeException {
        ArrayAccess arrayAccess2 = this.getArray(1, l, n2);
        System.arraycopy(arrayAccess2.getData(), arrayAccess2.getOffset(), arrayAccess.getData(), arrayAccess.getOffset() + n, n2);
        arrayAccess2.close();
    }

    private void writeFromArray(ArrayAccess arrayAccess, int n, long l, int n2) throws ApfloatRuntimeException {
        ArrayAccess arrayAccess2 = this.getArray(2, l, n2);
        System.arraycopy(arrayAccess.getData(), arrayAccess.getOffset() + n, arrayAccess2.getData(), arrayAccess2.getOffset(), n2);
        arrayAccess2.close();
    }

    public DataStorage.Iterator iterator(int n, long l, long l2) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
        if ((n & 3) == 0) {
            throw new IllegalArgumentException("Illegal mode: " + n);
        }
        return new BlockIterator(n, l, l2);
    }

    protected int getUnitSize() {
        return 4;
    }

    private class BlockIterator
    extends DataStorage.AbstractIterator {
        private ArrayAccess arrayAccess;
        private int[] data;
        private int offset;
        private int remaining;

        public BlockIterator(int n, long l, long l2) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
            super(IntDiskDataStorage.this, n, l, l2);
            this.arrayAccess = null;
            this.remaining = 0;
        }

        public void next() throws IllegalStateException, ApfloatRuntimeException {
            this.checkLength();
            assert (this.remaining > 0);
            this.checkAvailable();
            this.offset += this.getIncrement();
            --this.remaining;
            if (this.remaining == 0) {
                this.close();
            }
            super.next();
        }

        public int getInt() throws IllegalStateException, ApfloatRuntimeException {
            this.checkGet();
            this.checkAvailable();
            return this.data[this.offset];
        }

        public void setInt(int n) throws IllegalStateException, ApfloatRuntimeException {
            this.checkSet();
            this.checkAvailable();
            this.data[this.offset] = n;
        }

        public void close() throws ApfloatRuntimeException {
            if (this.arrayAccess != null) {
                this.data = null;
                this.arrayAccess.close();
                this.arrayAccess = null;
            }
        }

        private void checkAvailable() throws ApfloatRuntimeException {
            if (this.arrayAccess == null) {
                boolean bl = this.getIncrement() > 0;
                int n = (int)Math.min(this.getLength(), (long)(DiskDataStorage.getBlockSize() / 4));
                long l = bl ? this.getPosition() : this.getPosition() - (long)n + 1L;
                this.arrayAccess = IntDiskDataStorage.this.getArray(this.getMode(), l, n);
                this.data = this.arrayAccess.getIntData();
                this.offset = this.arrayAccess.getOffset() + (bl ? 0 : n - 1);
                this.remaining = n;
            }
        }
    }

    private class TransposedMemoryArrayAccess
    extends IntMemoryArrayAccess {
        private static final long serialVersionUID = 2990517367865486151L;
        private int mode;
        private int startColumn;
        private int columns;
        private int rows;

        public TransposedMemoryArrayAccess(int n, int[] nArray, int n2, int n3, int n4) {
            super(nArray, 0, nArray.length);
            this.mode = n;
            this.startColumn = n2;
            this.columns = n3;
            this.rows = n4;
        }

        public void close() throws ApfloatRuntimeException {
            if ((this.mode & 2) != 0 && this.getData() != null) {
                IntDiskDataStorage.this.setTransposedArray(this, this.startColumn, this.columns, this.rows);
            }
            super.close();
        }
    }

    private class IntDiskArrayAccess
    extends IntMemoryArrayAccess {
        private static final long serialVersionUID = -88509093904437138L;
        private int mode;
        private long fileOffset;

        public IntDiskArrayAccess(int n, long l, int n2) throws ApfloatRuntimeException {
            super(new int[n2], 0, n2);
            this.mode = n;
            this.fileOffset = l;
            if ((n & 1) != 0) {
                final int[] nArray = this.getIntData();
                WritableByteChannel writableByteChannel = new WritableByteChannel(){
                    private int readPosition = 0;

                    public int write(ByteBuffer byteBuffer) {
                        IntBuffer intBuffer = byteBuffer.asIntBuffer();
                        int n = intBuffer.remaining();
                        intBuffer.get(nArray, this.readPosition, n);
                        this.readPosition += n;
                        byteBuffer.position(byteBuffer.position() + n * 4);
                        return n * 4;
                    }

                    public void close() {
                    }

                    public boolean isOpen() {
                        return true;
                    }
                };
                IntDiskDataStorage.this.transferTo(writableByteChannel, l * 4L, (long)n2 * 4L);
            }
        }

        public void close() throws ApfloatRuntimeException {
            if ((this.mode & 2) != 0 && this.getData() != null) {
                final int[] nArray = this.getIntData();
                ReadableByteChannel readableByteChannel = new ReadableByteChannel(){
                    private int writePosition = 0;

                    public int read(ByteBuffer byteBuffer) {
                        IntBuffer intBuffer = byteBuffer.asIntBuffer();
                        int n = intBuffer.remaining();
                        intBuffer.put(nArray, this.writePosition, n);
                        this.writePosition += n;
                        byteBuffer.position(byteBuffer.position() + n * 4);
                        return n * 4;
                    }

                    public void close() {
                    }

                    public boolean isOpen() {
                        return true;
                    }
                };
                IntDiskDataStorage.this.transferFrom(readableByteChannel, this.fileOffset * 4L, (long)nArray.length * 4L);
            }
            super.close();
        }
    }
}

