/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.IntDiskDataStorage;
import org.apfloat.internal.IntMemoryDataStorage;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class IntDataStorageBuilder
implements DataStorageBuilder {
    public DataStorage createDataStorage(long l) throws ApfloatRuntimeException {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        if (l <= (long)apfloatContext.getMemoryTreshold()) {
            return new IntMemoryDataStorage();
        }
        return new IntDiskDataStorage();
    }

    public DataStorage createCachedDataStorage(long l) throws ApfloatRuntimeException {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        if (l <= apfloatContext.getMaxMemoryBlockSize()) {
            return new IntMemoryDataStorage();
        }
        return new IntDiskDataStorage();
    }

    public DataStorage createDataStorage(DataStorage dataStorage) throws ApfloatRuntimeException {
        ApfloatContext apfloatContext;
        long l;
        if (dataStorage instanceof IntMemoryDataStorage && (l = dataStorage.getSize()) > (long)(apfloatContext = ApfloatContext.getContext()).getMemoryTreshold()) {
            IntDiskDataStorage intDiskDataStorage = new IntDiskDataStorage();
            intDiskDataStorage.copyFrom(dataStorage);
            dataStorage = intDiskDataStorage;
        }
        return dataStorage;
    }
}

