/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.math.BigInteger;
import java.util.RandomAccess;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.IntCRTMath;
import org.apfloat.internal.IntModConstants;
import org.apfloat.internal.IntModMath;
import org.apfloat.internal.MessagePasser;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class IntCarryCRT
extends IntCRTMath {
    private static final long serialVersionUID = -3954870352092656433L;
    private static final IntModMath MATH_MOD_0 = new IntModMath();
    private static final IntModMath MATH_MOD_1 = new IntModMath();
    private static final IntModMath MATH_MOD_2 = new IntModMath();
    private static final int T0;
    private static final int T1;
    private static final int T2;
    private static final int[] M01;
    private static final int[] M02;
    private static final int[] M12;
    private static final int[] M012;
    private ParallelRunner parallelRunner;

    public IntCarryCRT(int n) {
        super(n);
    }

    public DataStorage carryCRT(final DataStorage dataStorage, final DataStorage dataStorage2, final DataStorage dataStorage3, final long l) throws ApfloatRuntimeException {
        Object object;
        final long l2 = Math.min(l + 2L, dataStorage.getSize());
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = apfloatContext.getBuilderFactory().getDataStorageBuilder();
        final DataStorage dataStorage4 = dataStorageBuilder.createDataStorage(l * 8L);
        dataStorage4.setSize(l);
        final MessagePasser<Long, int[]> messagePasser = new MessagePasser<Long, int[]>();
        if (l2 <= Integer.MAX_VALUE && this.parallelRunner != null && dataStorage instanceof RandomAccess && dataStorage2 instanceof RandomAccess && dataStorage3 instanceof RandomAccess && dataStorage4 instanceof RandomAccess) {
            object = new ParallelRunnable(){

                public int getLength() {
                    return (int)l2;
                }

                public Runnable getRunnable(int n, int n2) {
                    return new CarryCRTRunnable(dataStorage, dataStorage2, dataStorage3, dataStorage4, l2, l, n, n2, messagePasser);
                }
            };
            this.parallelRunner.runParallel((ParallelRunnable)object);
        } else {
            new CarryCRTRunnable(dataStorage, dataStorage2, dataStorage3, dataStorage4, l2, l, 0L, l2, messagePasser).run();
        }
        object = null;
        assert ((object = messagePasser.getMessage(l2)) != null);
        assert ((object).length == 2);
        assert (object[0] == 0);
        assert (object[1] == 0);
        return dataStorage4;
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        this.parallelRunner = parallelRunner;
    }

    private static DataStorage.Iterator arrayIterator(final int[] nArray) {
        return new DataStorage.Iterator(){
            private int position;
            {
                this.position = nArray.length - 1;
            }

            public boolean hasNext() {
                return true;
            }

            public void next() {
                --this.position;
            }

            public int getInt() {
                assert (this.position >= 0);
                return nArray[this.position];
            }

            public void setInt(int n) {
                assert (this.position >= 0);
                nArray[this.position] = n;
            }
        };
    }

    private static DataStorage.Iterator compositeIterator(final DataStorage.Iterator iterator, final long l, final DataStorage.Iterator iterator2) {
        return new DataStorage.Iterator(){
            private long position;

            public boolean hasNext() {
                return this.position < l ? iterator.hasNext() : iterator2.hasNext();
            }

            public void next() {
                (this.position < l ? iterator : iterator2).next();
                ++this.position;
            }

            public int getInt() {
                return (this.position < l ? iterator : iterator2).getInt();
            }

            public void setInt(int n) {
                (this.position < l ? iterator : iterator2).setInt(n);
            }

            public void close() throws ApfloatRuntimeException {
                (this.position < l ? iterator : iterator2).close();
            }
        };
    }

    static {
        MATH_MOD_0.setModulus(IntModConstants.MODULUS[0]);
        MATH_MOD_1.setModulus(IntModConstants.MODULUS[1]);
        MATH_MOD_2.setModulus(IntModConstants.MODULUS[2]);
        BigInteger bigInteger = BigInteger.valueOf(Math.abs(Integer.MIN_VALUE));
        BigInteger bigInteger2 = BigInteger.valueOf(IntModConstants.MODULUS[0]);
        BigInteger bigInteger3 = BigInteger.valueOf(IntModConstants.MODULUS[1]);
        BigInteger bigInteger4 = BigInteger.valueOf(IntModConstants.MODULUS[2]);
        BigInteger bigInteger5 = bigInteger2.multiply(bigInteger3);
        BigInteger bigInteger6 = bigInteger2.multiply(bigInteger4);
        BigInteger bigInteger7 = bigInteger3.multiply(bigInteger4);
        T0 = bigInteger7.modInverse(bigInteger2).intValue();
        T1 = bigInteger6.modInverse(bigInteger3).intValue();
        T2 = bigInteger5.modInverse(bigInteger4).intValue();
        M01 = new int[2];
        M02 = new int[2];
        M12 = new int[2];
        M012 = new int[3];
        BigInteger[] bigIntegerArray = bigInteger5.divideAndRemainder(bigInteger);
        IntCarryCRT.M01[0] = bigIntegerArray[0].intValue();
        IntCarryCRT.M01[1] = bigIntegerArray[1].intValue();
        bigIntegerArray = bigInteger6.divideAndRemainder(bigInteger);
        IntCarryCRT.M02[0] = bigIntegerArray[0].intValue();
        IntCarryCRT.M02[1] = bigIntegerArray[1].intValue();
        bigIntegerArray = bigInteger7.divideAndRemainder(bigInteger);
        IntCarryCRT.M12[0] = bigIntegerArray[0].intValue();
        IntCarryCRT.M12[1] = bigIntegerArray[1].intValue();
        bigIntegerArray = bigInteger2.multiply(bigInteger7).divideAndRemainder(bigInteger);
        IntCarryCRT.M012[2] = bigIntegerArray[1].intValue();
        bigIntegerArray = bigIntegerArray[0].divideAndRemainder(bigInteger);
        IntCarryCRT.M012[0] = bigIntegerArray[0].intValue();
        IntCarryCRT.M012[1] = bigIntegerArray[1].intValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CarryCRTRunnable
    implements Runnable {
        private DataStorage resultMod0;
        private DataStorage resultMod1;
        private DataStorage resultMod2;
        private DataStorage dataStorage;
        private long size;
        private long resultSize;
        private long offset;
        private long length;
        private MessagePasser<Long, int[]> messagePasser;

        public CarryCRTRunnable(DataStorage dataStorage, DataStorage dataStorage2, DataStorage dataStorage3, DataStorage dataStorage4, long l, long l2, long l3, long l4, MessagePasser<Long, int[]> messagePasser) {
            this.resultMod0 = dataStorage;
            this.resultMod1 = dataStorage2;
            this.resultMod2 = dataStorage3;
            this.dataStorage = dataStorage4;
            this.size = l;
            this.resultSize = l2;
            this.offset = l3;
            this.length = l4;
            this.messagePasser = messagePasser;
        }

        @Override
        public void run() {
            int n;
            long l = this.offset == 0L ? this.size - this.resultSize + 1L : 0L;
            long l2 = this.offset + this.length == this.size ? 1 : 0;
            long l3 = 1L - l2;
            long l4 = this.length - l + l2;
            long l5 = this.size - this.offset;
            long l6 = l5 - this.length;
            long l7 = this.size - this.offset - this.length + l3 + l4;
            long l8 = l7 - l4;
            DataStorage.Iterator iterator = this.resultMod0.iterator(1, l5, l6);
            DataStorage.Iterator iterator2 = this.resultMod1.iterator(1, l5, l6);
            DataStorage.Iterator iterator3 = this.resultMod2.iterator(1, l5, l6);
            DataStorage.Iterator iterator4 = this.dataStorage.iterator(2, l7, l8);
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            int[] nArray3 = new int[3];
            for (long i = 0L; i < this.length; ++i) {
                int n2 = MATH_MOD_0.modMultiply(T0, iterator.getInt());
                int n3 = MATH_MOD_1.modMultiply(T1, iterator2.getInt());
                int n4 = MATH_MOD_2.modMultiply(T2, iterator3.getInt());
                IntCarryCRT.this.multiply(M12, n2, nArray2);
                IntCarryCRT.this.multiply(M02, n3, nArray3);
                if (IntCarryCRT.this.add(nArray3, nArray2) != 0 || IntCarryCRT.this.compare(nArray2, M012) >= 0) {
                    IntCarryCRT.this.subtract(M012, nArray2);
                }
                IntCarryCRT.this.multiply(M01, n4, nArray3);
                if (IntCarryCRT.this.add(nArray3, nArray2) != 0 || IntCarryCRT.this.compare(nArray2, M012) >= 0) {
                    IntCarryCRT.this.subtract(M012, nArray2);
                }
                IntCarryCRT.this.add(nArray2, nArray);
                n = IntCarryCRT.this.divide(nArray);
                if (i >= l) {
                    iterator4.setInt(n);
                    iterator4.next();
                }
                iterator.next();
                iterator2.next();
                iterator3.next();
            }
            int n5 = IntCarryCRT.this.divide(nArray);
            int n6 = nArray[2];
            assert (nArray[0] == 0);
            assert (nArray[1] == 0);
            if (l4 == this.length - l + 1L) {
                iterator4.setInt(n5);
                iterator4.close();
                n5 = n6;
                assert (n6 == 0);
            }
            int[] nArray4 = new int[]{n6, n5};
            if (this.offset > 0L) {
                int[] nArray5 = this.messagePasser.receiveMessage(this.offset);
                DataStorage.Iterator iterator5 = IntCarryCRT.arrayIterator(nArray5);
                iterator4 = IntCarryCRT.compositeIterator(this.dataStorage.iterator(3, l7, l8), l4, IntCarryCRT.arrayIterator(nArray4));
                n = IntCarryCRT.this.baseAdd(iterator4, iterator5, 0, iterator4, nArray5.length);
                n = this.baseCarry(iterator4, n, l4);
                iterator4.close();
                assert (n == 0);
            }
            this.messagePasser.sendMessage(this.offset + this.length, nArray4);
        }

        private int baseCarry(DataStorage.Iterator iterator, int n, long l) {
            for (long i = 0L; i < l && n > 0; ++i) {
                n = IntCarryCRT.this.baseAdd(iterator, null, n, iterator, 1L);
            }
            return n;
        }
    }
}

