/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.internal.IntBaseMath;
import org.apfloat.internal.IntRadixConstants;

public class IntCRTMath
extends IntBaseMath {
    private static final long serialVersionUID = 6698972116690441263L;
    private static final int BASE_MASK = Integer.MAX_VALUE;
    private int base;

    public IntCRTMath(int n) {
        super(n);
        this.base = IntRadixConstants.BASE[n];
    }

    public final void multiply(int[] nArray, int n, int[] nArray2) {
        long l = (long)nArray[1] * (long)n;
        int n2 = (int)(l >>> 31);
        nArray2[2] = (int)l & Integer.MAX_VALUE;
        l = (long)nArray[0] * (long)n + (long)n2;
        n2 = (int)(l >>> 31);
        nArray2[1] = (int)l & Integer.MAX_VALUE;
        nArray2[0] = n2;
    }

    public final int compare(int[] nArray, int[] nArray2) {
        int n = nArray[0] - nArray2[0];
        if (n != 0) {
            return n;
        }
        n = nArray[1] - nArray2[1];
        if (n != 0) {
            return n;
        }
        return nArray[2] - nArray2[2];
    }

    public final int add(int[] nArray, int[] nArray2) {
        int n = nArray2[2] + nArray[2];
        int n2 = n < 0 ? 1 : 0;
        nArray2[2] = n = n < 0 ? n - Integer.MIN_VALUE : n;
        n = nArray2[1] + nArray[1] + n2;
        n2 = n < 0 ? 1 : 0;
        nArray2[1] = n = n < 0 ? n - Integer.MIN_VALUE : n;
        n = nArray2[0] + nArray[0] + n2;
        n2 = n < 0 ? 1 : 0;
        nArray2[0] = n = n < 0 ? n - Integer.MIN_VALUE : n;
        return n2;
    }

    public final void subtract(int[] nArray, int[] nArray2) {
        int n = nArray2[2] - nArray[2];
        int n2 = n < 0 ? 1 : 0;
        nArray2[2] = n = n < 0 ? n + Integer.MIN_VALUE : n;
        n = nArray2[1] - nArray[1] - n2;
        n2 = n < 0 ? 1 : 0;
        nArray2[1] = n = n < 0 ? n + Integer.MIN_VALUE : n;
        n = nArray2[0] - nArray[0] - n2;
        nArray2[0] = n = n < 0 ? n + Integer.MIN_VALUE : n;
    }

    public final int divide(int[] nArray) {
        long l = ((long)nArray[0] << 31) + (long)nArray[1];
        int n = (int)(l / (long)this.base);
        int n2 = (int)l - n * this.base;
        nArray[0] = 0;
        nArray[1] = n;
        l = ((long)n2 << 31) + (long)nArray[2];
        n = (int)(l / (long)this.base);
        n2 = (int)l - n * this.base;
        nArray[2] = n;
        return n2;
    }
}

