/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.io.Serializable;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.IntRadixConstants;
import org.apfloat.spi.DataStorage;

public class IntBaseMath
implements Serializable {
    private static final long serialVersionUID = 2173589976837534455L;
    private int radix;

    public IntBaseMath(int n) {
        this.radix = n;
    }

    public int baseAdd(DataStorage.Iterator iterator, DataStorage.Iterator iterator2, int n, DataStorage.Iterator iterator3, long l) throws ApfloatRuntimeException {
        assert (iterator == null || iterator != iterator2);
        boolean bl = iterator == iterator3 || iterator2 == iterator3;
        int n2 = IntRadixConstants.BASE[this.radix];
        for (long i = 0L; i < l; ++i) {
            int n3 = (iterator == null ? 0 : iterator.getInt()) + n + (iterator2 == null ? 0 : iterator2.getInt());
            if (n3 >= n2 | n3 < 0) {
                n3 -= n2;
                n = 1;
            } else {
                n = 0;
            }
            iterator3.setInt(n3);
            if (iterator != null) {
                iterator.next();
            }
            if (iterator2 != null) {
                iterator2.next();
            }
            if (bl) continue;
            iterator3.next();
        }
        return n;
    }

    public int baseSubtract(DataStorage.Iterator iterator, DataStorage.Iterator iterator2, int n, DataStorage.Iterator iterator3, long l) throws ApfloatRuntimeException {
        assert (iterator == null || iterator != iterator2);
        assert (iterator2 != iterator3);
        int n2 = IntRadixConstants.BASE[this.radix];
        for (long i = 0L; i < l; ++i) {
            int n3 = (iterator == null ? 0 : iterator.getInt()) - n - (iterator2 == null ? 0 : iterator2.getInt());
            if (n3 < 0) {
                n3 += n2;
                n = 1;
            } else {
                n = 0;
            }
            iterator3.setInt(n3);
            if (iterator != null && iterator != iterator3) {
                iterator.next();
            }
            if (iterator2 != null) {
                iterator2.next();
            }
            iterator3.next();
        }
        return n;
    }

    public int baseMultiplyAdd(DataStorage.Iterator iterator, DataStorage.Iterator iterator2, int n, int n2, DataStorage.Iterator iterator3, long l) throws ApfloatRuntimeException {
        assert (iterator != iterator2);
        assert (iterator != iterator3);
        int n3 = IntRadixConstants.BASE[this.radix];
        for (long i = 0L; i < l; ++i) {
            long l2 = (long)iterator.getInt() * (long)n + (long)(iterator2 == null ? 0 : iterator2.getInt()) + (long)n2;
            n2 = (int)(l2 / (long)n3);
            iterator3.setInt((int)l2 - n2 * n3);
            iterator.next();
            if (iterator2 != null && iterator2 != iterator3) {
                iterator2.next();
            }
            iterator3.next();
        }
        return n2;
    }

    public int baseDivide(DataStorage.Iterator iterator, int n, int n2, DataStorage.Iterator iterator2, long l) throws ApfloatRuntimeException {
        assert (iterator != iterator2);
        int n3 = IntRadixConstants.BASE[this.radix];
        for (long i = 0L; i < l; ++i) {
            long l2 = (long)n2 * (long)n3 + (long)(iterator == null ? 0 : iterator.getInt());
            int n4 = (int)(l2 / (long)n);
            n2 = (int)l2 - n4 * n;
            iterator2.setInt(n4);
            if (iterator != null) {
                iterator.next();
            }
            iterator2.next();
        }
        return n2;
    }
}

