/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.FloatModConstants;
import org.apfloat.internal.FloatModMath;
import org.apfloat.internal.FloatScramble;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.NTTStrategy;
import org.apfloat.spi.Util;

public class FloatTableFNTStrategy
extends FloatModMath
implements NTTStrategy {
    public void transform(DataStorage dataStorage, int n) throws ApfloatRuntimeException {
        long l = dataStorage.getSize();
        if (l > 393216L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + l + " > " + 393216L);
        }
        if (l > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l);
        }
        this.setModulus(FloatModConstants.MODULUS[n]);
        float f = this.getForwardNthRoot(FloatModConstants.PRIMITIVE_ROOT[n], l);
        float[] fArray = this.createWTable(f, (int)l);
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l);
        this.tableFNT(arrayAccess, fArray, null);
        arrayAccess.close();
    }

    public void inverseTransform(DataStorage dataStorage, int n, long l) throws ApfloatRuntimeException {
        long l2 = dataStorage.getSize();
        if (Math.max(l2, l) > 393216L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(l2, l) + " > " + 393216L);
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l2);
        }
        this.setModulus(FloatModConstants.MODULUS[n]);
        float f = this.getInverseNthRoot(FloatModConstants.PRIMITIVE_ROOT[n], l2);
        float[] fArray = this.createWTable(f, (int)l2);
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l2);
        this.inverseTableFNT(arrayAccess, fArray, null);
        this.divideElements(arrayAccess, l);
        arrayAccess.close();
    }

    public long getTransformLength(long l) {
        return Util.round2up(l);
    }

    protected void tableFNT(ArrayAccess arrayAccess, float[] fArray, int[] nArray) throws ApfloatRuntimeException {
        float[] fArray2 = arrayAccess.getFloatData();
        int n = arrayAccess.getOffset();
        int n2 = arrayAccess.getLength();
        assert (n2 == (n2 & -n2));
        if (n2 < 2) {
            return;
        }
        int n3 = 1;
        for (int i = n2 >> 1; i > 0; i >>= 1) {
            int n4;
            int n5;
            int n6 = i << 1;
            for (n5 = n; n5 < n + n2; n5 += n6) {
                n4 = n5 + i;
                float f = fArray2[n5];
                float f2 = fArray2[n4];
                fArray2[n5] = this.modAdd(f, f2);
                fArray2[n4] = this.modSubtract(f, f2);
            }
            n5 = n3;
            for (n4 = 1; n4 < i; ++n4) {
                for (int j = n + n4; j < n + n2; j += n6) {
                    int n7 = j + i;
                    float f = fArray2[j];
                    float f3 = fArray2[n7];
                    fArray2[j] = this.modAdd(f, f3);
                    fArray2[n7] = this.modMultiply(fArray[n5], this.modSubtract(f, f3));
                }
                n5 += n3;
            }
            n3 <<= 1;
        }
        if (nArray != null) {
            FloatScramble.scramble(fArray2, n, nArray);
        }
    }

    protected void inverseTableFNT(ArrayAccess arrayAccess, float[] fArray, int[] nArray) throws ApfloatRuntimeException {
        float[] fArray2 = arrayAccess.getFloatData();
        int n = arrayAccess.getOffset();
        int n2 = arrayAccess.getLength();
        assert (n2 == (n2 & -n2));
        if (n2 < 2) {
            return;
        }
        if (nArray != null) {
            FloatScramble.scramble(fArray2, n, nArray);
        }
        int n3 = n2;
        int n4 = 1;
        while (n2 > n4) {
            int n5;
            int n6;
            int n7 = n4 << 1;
            n3 >>= 1;
            for (n6 = n; n6 < n + n2; n6 += n7) {
                n5 = n6 + n4;
                float f = fArray2[n5];
                fArray2[n5] = this.modSubtract(fArray2[n6], f);
                fArray2[n6] = this.modAdd(fArray2[n6], f);
            }
            n6 = n3;
            for (n5 = 1; n5 < n4; ++n5) {
                for (int i = n + n5; i < n + n2; i += n7) {
                    int n8 = i + n4;
                    float f = this.modMultiply(fArray[n6], fArray2[n8]);
                    fArray2[n8] = this.modSubtract(fArray2[i], f);
                    fArray2[i] = this.modAdd(fArray2[i], f);
                }
                n6 += n3;
            }
            n4 = n7;
        }
    }

    private void divideElements(ArrayAccess arrayAccess, float f) throws ApfloatRuntimeException {
        float f2 = this.modDivide(1.0f, f);
        float[] fArray = arrayAccess.getFloatData();
        int n = arrayAccess.getLength();
        int n2 = arrayAccess.getOffset();
        for (int i = 0; i < n; ++i) {
            fArray[i + n2] = this.modMultiply(fArray[i + n2], f2);
        }
    }
}

