/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.FloatTableFNTStrategy;
import org.apfloat.internal.ParallelNTTStrategy;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.spi.ArrayAccess;

public abstract class FloatParallelFNTStrategy
extends FloatTableFNTStrategy
implements ParallelNTTStrategy {
    protected ParallelRunner parallelRunner;

    protected FloatParallelFNTStrategy() {
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        this.parallelRunner = parallelRunner;
    }

    protected void multiplyElements(final ArrayAccess arrayAccess, final int n, final int n2, final int n3, final float f, final float f2) throws ApfloatRuntimeException {
        ParallelRunnable parallelRunnable = new ParallelRunnable(){

            public int getLength() {
                return n2;
            }

            public Runnable getRunnable(int n4, int n22) {
                ArrayAccess arrayAccess2 = arrayAccess.subsequence(n4 * n3, n22 * n3);
                return new MultiplyRunnable(arrayAccess2, n + n4, n22, n3, f, f2);
            }
        };
        this.parallelRunner.runParallel(parallelRunnable);
    }

    protected void transformRows(final int n, final int n2, final boolean bl, final ArrayAccess arrayAccess, final float[] fArray, final int[] nArray) throws ApfloatRuntimeException {
        ParallelRunnable parallelRunnable = new ParallelRunnable(){

            public int getLength() {
                return n2;
            }

            public Runnable getRunnable(int n3, int n22) {
                ArrayAccess arrayAccess2 = arrayAccess.subsequence(n3 * n, n22 * n);
                return new TableFNTRunnable(n, bl, arrayAccess2, fArray, nArray);
            }
        };
        this.parallelRunner.runParallel(parallelRunnable);
    }

    private class MultiplyRunnable
    implements Runnable {
        private ArrayAccess arrayAccess;
        private int startRow;
        private int rows;
        private int columns;
        private float w;
        private float scaleFactor;

        public MultiplyRunnable(ArrayAccess arrayAccess, int n, int n2, int n3, float f, float f2) {
            this.arrayAccess = arrayAccess;
            this.startRow = n;
            this.rows = n2;
            this.columns = n3;
            this.w = f;
            this.scaleFactor = f2;
        }

        public void run() {
            float[] fArray = this.arrayAccess.getFloatData();
            int n = this.arrayAccess.getOffset();
            float f = FloatParallelFNTStrategy.this.modPow(this.w, this.startRow);
            for (int i = 0; i < this.rows; ++i) {
                float f2 = this.scaleFactor;
                int n2 = 0;
                while (n2 < this.columns) {
                    fArray[n] = FloatParallelFNTStrategy.this.modMultiply(fArray[n], f2);
                    f2 = FloatParallelFNTStrategy.this.modMultiply(f2, f);
                    ++n2;
                    ++n;
                }
                f = FloatParallelFNTStrategy.this.modMultiply(f, this.w);
            }
        }
    }

    private class TableFNTRunnable
    implements Runnable {
        private int length;
        private boolean isInverse;
        private ArrayAccess arrayAccess;
        private float[] wTable;
        private int[] permutationTable;

        public TableFNTRunnable(int n, boolean bl, ArrayAccess arrayAccess, float[] fArray, int[] nArray) {
            this.length = n;
            this.isInverse = bl;
            this.arrayAccess = arrayAccess;
            this.wTable = fArray;
            this.permutationTable = nArray;
        }

        public void run() {
            int n = this.arrayAccess.getLength();
            for (int i = 0; i < n; i += this.length) {
                ArrayAccess arrayAccess = this.arrayAccess.subsequence(i, this.length);
                if (this.isInverse) {
                    FloatParallelFNTStrategy.this.inverseTableFNT(arrayAccess, this.wTable, this.permutationTable);
                    continue;
                }
                FloatParallelFNTStrategy.this.tableFNT(arrayAccess, this.wTable, this.permutationTable);
            }
        }
    }
}

