/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.internal.FloatElementaryModMath;

public class FloatModMath
extends FloatElementaryModMath {
    public final float[] createWTable(float f, int n) {
        float[] fArray = new float[n];
        float f2 = 1.0f;
        for (int i = 0; i < n; ++i) {
            fArray[i] = f2;
            f2 = this.modMultiply(f2, f);
        }
        return fArray;
    }

    public float getForwardNthRoot(float f, long l) {
        return this.modPow(f, this.getModulus() - 1.0f - (this.getModulus() - 1.0f) / (float)l);
    }

    public float getInverseNthRoot(float f, long l) {
        return this.modPow(f, (this.getModulus() - 1.0f) / (float)l);
    }

    public final float modInverse(float f) {
        return this.modPow(f, this.getModulus() - 2.0f);
    }

    public final float modDivide(float f, float f2) {
        return this.modMultiply(f, this.modInverse(f2));
    }

    public final float negate(float f) {
        return f == 0.0f ? 0.0f : this.getModulus() - f;
    }

    public final float modPow(float f, float f2) {
        assert (f != 0.0f || f2 != 0.0f);
        if (f2 == 0.0f) {
            return 1.0f;
        }
        if (f2 < 0.0f) {
            return this.modPow(f, this.getModulus() - 1.0f + f2);
        }
        long l = (long)f2;
        while ((l & 1L) == 0L) {
            f = this.modMultiply(f, f);
            l >>= 1;
        }
        float f3 = f;
        while ((l >>= 1) > 0L) {
            f = this.modMultiply(f, f);
            if ((l & 1L) == 0L) continue;
            f3 = this.modMultiply(f3, f);
        }
        return f3;
    }
}

