/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.util.RandomAccess;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.FloatMemoryArrayAccess;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;

public class FloatMemoryDataStorage
extends DataStorage
implements RandomAccess {
    private static final long serialVersionUID = -862001153825924236L;
    private float[] data;

    public FloatMemoryDataStorage() {
        this.data = new float[0];
    }

    protected FloatMemoryDataStorage(FloatMemoryDataStorage floatMemoryDataStorage, long l, long l2) {
        super(floatMemoryDataStorage, l, l2);
        this.data = floatMemoryDataStorage.data;
    }

    protected DataStorage implSubsequence(long l, long l2) throws ApfloatRuntimeException {
        return new FloatMemoryDataStorage(this, l + this.getOffset(), l2);
    }

    protected void implCopyFrom(DataStorage dataStorage, long l) throws ApfloatRuntimeException {
        assert (l > 0L);
        assert (!this.isReadOnly());
        assert (!this.isSubsequenced());
        if (l > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Size too big for memory array: " + l);
        }
        this.data = new float[(int)l];
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        int n = (int)Math.min(l, dataStorage.getSize());
        int n2 = 0;
        int n3 = apfloatContext.getBlockSize() / 4;
        while (n > 0) {
            int n4 = Math.min(n3, n);
            ArrayAccess arrayAccess = dataStorage.getArray(1, n2, n4);
            System.arraycopy(arrayAccess.getFloatData(), arrayAccess.getOffset(), this.data, n2, n4);
            arrayAccess.close();
            n -= n4;
            n2 += n4;
        }
    }

    protected long implGetSize() {
        return this.data.length;
    }

    protected void implSetSize(long l) throws ApfloatRuntimeException {
        assert (l > 0L);
        assert (!this.isReadOnly());
        assert (!this.isSubsequenced());
        if (l == (long)this.data.length) {
            return;
        }
        if (l > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Size too big for memory array: " + l);
        }
        int n = (int)l;
        float[] fArray = new float[n];
        System.arraycopy(this.data, 0, fArray, 0, Math.min(this.data.length, n));
        this.data = fArray;
    }

    protected ArrayAccess implGetArray(int n, long l, int n2) throws ApfloatRuntimeException {
        return new FloatMemoryArrayAccess(this.data, (int)(l + this.getOffset()), n2);
    }

    protected ArrayAccess implGetTransposedArray(int n, int n2, int n3, int n4) throws ApfloatRuntimeException {
        throw new ApfloatInternalException("Method not implemented - would be sub-optimal; change the apfloat configuration settings");
    }

    public DataStorage.Iterator iterator(int n, long l, long l2) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
        ReadWriteIterator readWriteIterator;
        switch (n & 3) {
            case 1: {
                readWriteIterator = new ReadOnlyIterator(l, l2);
                break;
            }
            case 2: {
                readWriteIterator = new WriteOnlyIterator(l, l2);
                break;
            }
            case 3: {
                readWriteIterator = new ReadWriteIterator(l, l2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal mode: " + n);
            }
        }
        return readWriteIterator;
    }

    private class WriteOnlyIterator
    extends ReadWriteIterator {
        public WriteOnlyIterator(long l, long l2) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
            super(2, l, l2);
        }

        public float getFloat() throws IllegalStateException {
            throw new IllegalStateException("Not a readable iterator");
        }
    }

    private class ReadOnlyIterator
    extends ReadWriteIterator {
        public ReadOnlyIterator(long l, long l2) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
            super(1, l, l2);
        }

        public void setFloat(float f) throws IllegalStateException {
            throw new IllegalStateException("Not a writable iterator");
        }
    }

    private class ReadWriteIterator
    extends DataStorage.AbstractIterator {
        private float[] data;
        private int position;
        private int length;

        public ReadWriteIterator(long l, long l2) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
            this(3, l, l2);
        }

        protected ReadWriteIterator(int n, long l, long l2) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
            super(FloatMemoryDataStorage.this, n, l, l2);
            this.data = FloatMemoryDataStorage.this.data;
            this.position = (int)this.getPosition() + (int)FloatMemoryDataStorage.this.getOffset();
            this.length = (int)this.getLength();
        }

        public boolean hasNext() {
            return this.length > 0;
        }

        public void next() throws IllegalStateException {
            this.checkLength();
            this.position += this.getIncrement();
            --this.length;
        }

        public float getFloat() throws IllegalStateException {
            this.checkLength();
            return this.data[this.position];
        }

        public void setFloat(float f) throws IllegalStateException {
            this.checkLength();
            this.data[this.position] = f;
        }

        protected void checkLength() throws IllegalStateException {
            if (this.length == 0) {
                throw new IllegalStateException("At the end of iterator");
            }
        }
    }
}

