/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.FloatBaseMath;
import org.apfloat.spi.ConvolutionStrategy;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class FloatMediumConvolutionStrategy
extends FloatBaseMath
implements ConvolutionStrategy {
    private static final long serialVersionUID = -6697305140738370764L;

    public FloatMediumConvolutionStrategy(int n) {
        super(n);
    }

    public DataStorage convolute(DataStorage dataStorage, DataStorage dataStorage2, long l) throws ApfloatRuntimeException {
        DataStorage dataStorage3;
        DataStorage dataStorage4;
        if (dataStorage.getSize() > dataStorage2.getSize()) {
            dataStorage4 = dataStorage2;
            dataStorage3 = dataStorage;
        } else {
            dataStorage4 = dataStorage;
            dataStorage3 = dataStorage2;
        }
        long l2 = dataStorage4.getSize();
        long l3 = dataStorage3.getSize();
        long l4 = l2 + l3;
        if (l2 > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Too long shorter number, size = " + l2);
        }
        final int n = (int)l2;
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = apfloatContext.getBuilderFactory().getDataStorageBuilder();
        DataStorage dataStorage5 = dataStorageBuilder.createDataStorage(l4 * 4L);
        dataStorage5.setSize(l4);
        DataStorage.Iterator iterator = dataStorage3.iterator(1, l3, 0L);
        DataStorage.Iterator iterator2 = dataStorage5.iterator(2, l4, 0L);
        DataStorage.Iterator iterator3 = new DataStorage.Iterator(){
            private float[] buffer;
            private int position;
            {
                this.buffer = new float[n];
                this.position = 0;
            }

            public void next() {
                ++this.position;
                this.position = this.position == n ? 0 : this.position;
            }

            public float getFloat() {
                return this.buffer[this.position];
            }

            public void setFloat(float f) {
                this.buffer[this.position] = f;
            }
        };
        for (long i = 0L; i < l3; ++i) {
            DataStorage.Iterator iterator4 = dataStorage4.iterator(1, l2, 0L);
            float f = iterator.getFloat();
            float f2 = this.baseMultiplyAdd(iterator4, iterator3, f, 0.0f, iterator3, l2);
            float f3 = iterator3.getFloat();
            iterator2.setFloat(f3);
            iterator3.setFloat(f2);
            iterator3.next();
            iterator.next();
            iterator2.next();
        }
        for (int i = 0; i < n; ++i) {
            float f = iterator3.getFloat();
            iterator2.setFloat(f);
            iterator3.next();
            iterator2.next();
        }
        return dataStorage5;
    }
}

