/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.FloatModConstants;
import org.apfloat.internal.FloatParallelFNTStrategy;
import org.apfloat.internal.FloatSixStepFNTStrategy;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.Util;

public class FloatFactor3SixStepNTTStrategy
extends FloatParallelFNTStrategy {
    private FloatSixStepFNTStrategy factor2Strategy;

    public FloatFactor3SixStepNTTStrategy(FloatSixStepFNTStrategy floatSixStepFNTStrategy) {
        this.factor2Strategy = floatSixStepFNTStrategy;
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        super.setParallelRunner(parallelRunner);
        this.factor2Strategy.setParallelRunner(parallelRunner);
    }

    public void transform(DataStorage dataStorage, int n) throws ApfloatRuntimeException {
        long l = dataStorage.getSize();
        if (l > 393216L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + l + " > " + 393216L);
        }
        if (l > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l);
        }
        int n2 = (int)(l & -l);
        if (l == (long)n2) {
            this.factor2Strategy.transform(dataStorage, n);
        } else {
            assert (l == (long)(3 * n2));
            this.setModulus(FloatModConstants.MODULUS[n]);
            float f = this.getForwardNthRoot(FloatModConstants.PRIMITIVE_ROOT[n], l);
            float f2 = this.modPow(f, n2);
            ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l);
            ArrayAccess arrayAccess2 = arrayAccess.subsequence(0, n2);
            ArrayAccess arrayAccess3 = arrayAccess.subsequence(n2, n2);
            ArrayAccess arrayAccess4 = arrayAccess.subsequence(2 * n2, n2);
            this.transformColumns(false, arrayAccess2, arrayAccess3, arrayAccess4, n2, f, f2);
            this.factor2Strategy.transform(arrayAccess2, n);
            this.factor2Strategy.transform(arrayAccess3, n);
            this.factor2Strategy.transform(arrayAccess4, n);
            arrayAccess.close();
        }
    }

    public void inverseTransform(DataStorage dataStorage, int n, long l) throws ApfloatRuntimeException {
        long l2 = dataStorage.getSize();
        if (Math.max(l2, l) > 393216L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(l2, l) + " > " + 393216L);
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l2);
        }
        int n2 = (int)(l2 & -l2);
        if (l2 == (long)n2) {
            this.factor2Strategy.inverseTransform(dataStorage, n, l);
        } else {
            assert (l2 == (long)(3 * n2));
            this.setModulus(FloatModConstants.MODULUS[n]);
            float f = this.getInverseNthRoot(FloatModConstants.PRIMITIVE_ROOT[n], l2);
            float f2 = this.modPow(f, n2);
            ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l2);
            ArrayAccess arrayAccess2 = arrayAccess.subsequence(0, n2);
            ArrayAccess arrayAccess3 = arrayAccess.subsequence(n2, n2);
            ArrayAccess arrayAccess4 = arrayAccess.subsequence(2 * n2, n2);
            this.factor2Strategy.inverseTransform(arrayAccess2, n, l);
            this.factor2Strategy.inverseTransform(arrayAccess3, n, l);
            this.factor2Strategy.inverseTransform(arrayAccess4, n, l);
            this.transformColumns(true, arrayAccess2, arrayAccess3, arrayAccess4, n2, f, f2);
            arrayAccess.close();
        }
    }

    public long getTransformLength(long l) {
        return Util.round23up(l);
    }

    private void transformColumns(final boolean bl, final ArrayAccess arrayAccess, final ArrayAccess arrayAccess2, final ArrayAccess arrayAccess3, final int n, final float f, float f2) throws ApfloatRuntimeException {
        final float f3 = this.modMultiply(f, f);
        final float f4 = this.negate(this.modDivide(3.0f, 2.0f));
        final float f5 = this.modAdd(f2, this.modDivide(1.0f, 2.0f));
        ParallelRunnable parallelRunnable = new ParallelRunnable(){

            public int getLength() {
                return n;
            }

            public Runnable getRunnable(int n3, int n2) {
                return new ColumnTransformRunnable(bl, arrayAccess, arrayAccess2, arrayAccess3, n3, n2, f, f3, f4, f5);
            }
        };
        this.parallelRunner.runParallel(parallelRunnable);
    }

    private class ColumnTransformRunnable
    implements Runnable {
        private boolean isInverse;
        private ArrayAccess arrayAccess0;
        private ArrayAccess arrayAccess1;
        private ArrayAccess arrayAccess2;
        private int startColumn;
        private int columns;
        private float w;
        private float ww;
        private float w1;
        private float w2;

        public ColumnTransformRunnable(boolean bl, ArrayAccess arrayAccess, ArrayAccess arrayAccess2, ArrayAccess arrayAccess3, int n, int n2, float f, float f2, float f3, float f4) {
            this.isInverse = bl;
            this.arrayAccess0 = arrayAccess;
            this.arrayAccess1 = arrayAccess2;
            this.arrayAccess2 = arrayAccess3;
            this.startColumn = n;
            this.columns = n2;
            this.w = f;
            this.ww = f2;
            this.w1 = f3;
            this.w2 = f4;
        }

        public void run() {
            float f = FloatFactor3SixStepNTTStrategy.this.modPow(this.w, this.startColumn);
            float f2 = FloatFactor3SixStepNTTStrategy.this.modPow(this.ww, this.startColumn);
            float[] fArray = this.arrayAccess0.getFloatData();
            float[] fArray2 = this.arrayAccess1.getFloatData();
            float[] fArray3 = this.arrayAccess2.getFloatData();
            int n = this.arrayAccess0.getOffset() + this.startColumn;
            int n2 = this.arrayAccess1.getOffset() + this.startColumn;
            int n3 = this.arrayAccess2.getOffset() + this.startColumn;
            for (int i = 0; i < this.columns; ++i) {
                float f3 = fArray[n + i];
                float f4 = fArray2[n2 + i];
                float f5 = fArray3[n3 + i];
                if (this.isInverse) {
                    f4 = FloatFactor3SixStepNTTStrategy.this.modMultiply(f4, f);
                    f5 = FloatFactor3SixStepNTTStrategy.this.modMultiply(f5, f2);
                }
                float f6 = FloatFactor3SixStepNTTStrategy.this.modAdd(f4, f5);
                f5 = FloatFactor3SixStepNTTStrategy.this.modSubtract(f4, f5);
                f3 = FloatFactor3SixStepNTTStrategy.this.modAdd(f3, f6);
                f6 = FloatFactor3SixStepNTTStrategy.this.modMultiply(f6, this.w1);
                f5 = FloatFactor3SixStepNTTStrategy.this.modMultiply(f5, this.w2);
                f6 = FloatFactor3SixStepNTTStrategy.this.modAdd(f6, f3);
                f4 = FloatFactor3SixStepNTTStrategy.this.modAdd(f6, f5);
                f5 = FloatFactor3SixStepNTTStrategy.this.modSubtract(f6, f5);
                if (!this.isInverse) {
                    f4 = FloatFactor3SixStepNTTStrategy.this.modMultiply(f4, f);
                    f5 = FloatFactor3SixStepNTTStrategy.this.modMultiply(f5, f2);
                }
                fArray[n + i] = f3;
                fArray2[n2 + i] = f4;
                fArray3[n3 + i] = f5;
                f = FloatFactor3SixStepNTTStrategy.this.modMultiply(f, this.w);
                f2 = FloatFactor3SixStepNTTStrategy.this.modMultiply(f2, this.ww);
            }
        }
    }
}

