/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.FloatModConstants;
import org.apfloat.internal.FloatModMath;
import org.apfloat.internal.ParallelNTTStrategy;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.NTTStrategy;
import org.apfloat.spi.Util;

public class FloatFactor3NTTStrategy
extends FloatModMath
implements ParallelNTTStrategy {
    private NTTStrategy factor2Strategy;

    public FloatFactor3NTTStrategy(NTTStrategy nTTStrategy) {
        this.factor2Strategy = nTTStrategy;
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        if (this.factor2Strategy instanceof ParallelNTTStrategy) {
            ((ParallelNTTStrategy)this.factor2Strategy).setParallelRunner(parallelRunner);
        }
    }

    public void transform(DataStorage dataStorage, int n) throws ApfloatRuntimeException {
        long l = dataStorage.getSize();
        long l2 = l & -l;
        if (l > 393216L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + l + " > " + 393216L);
        }
        if (l == l2) {
            this.factor2Strategy.transform(dataStorage, n);
        } else {
            assert (l == 3L * l2);
            this.setModulus(FloatModConstants.MODULUS[n]);
            float f = this.getForwardNthRoot(FloatModConstants.PRIMITIVE_ROOT[n], l);
            float f2 = this.modPow(f, l2);
            DataStorage dataStorage2 = dataStorage.subsequence(0L, l2);
            DataStorage dataStorage3 = dataStorage.subsequence(l2, l2);
            DataStorage dataStorage4 = dataStorage.subsequence(2L * l2, l2);
            this.transformColumns(false, dataStorage2, dataStorage3, dataStorage4, l2, f, f2);
            this.factor2Strategy.transform(dataStorage2, n);
            this.factor2Strategy.transform(dataStorage3, n);
            this.factor2Strategy.transform(dataStorage4, n);
        }
    }

    public void inverseTransform(DataStorage dataStorage, int n, long l) throws ApfloatRuntimeException {
        long l2 = dataStorage.getSize();
        long l3 = l2 & -l2;
        if (Math.max(l2, l) > 393216L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(l2, l) + " > " + 393216L);
        }
        if (l2 == l3) {
            this.factor2Strategy.inverseTransform(dataStorage, n, l);
        } else {
            assert (l2 == 3L * l3);
            this.setModulus(FloatModConstants.MODULUS[n]);
            float f = this.getInverseNthRoot(FloatModConstants.PRIMITIVE_ROOT[n], l2);
            float f2 = this.modPow(f, l3);
            DataStorage dataStorage2 = dataStorage.subsequence(0L, l3);
            DataStorage dataStorage3 = dataStorage.subsequence(l3, l3);
            DataStorage dataStorage4 = dataStorage.subsequence(2L * l3, l3);
            this.factor2Strategy.inverseTransform(dataStorage2, n, l);
            this.factor2Strategy.inverseTransform(dataStorage3, n, l);
            this.factor2Strategy.inverseTransform(dataStorage4, n, l);
            this.transformColumns(true, dataStorage2, dataStorage3, dataStorage4, l3, f, f2);
        }
    }

    public long getTransformLength(long l) {
        return Util.round23up(l);
    }

    private void transformColumns(boolean bl, DataStorage dataStorage, DataStorage dataStorage2, DataStorage dataStorage3, long l, float f, float f2) throws ApfloatRuntimeException {
        DataStorage.Iterator iterator = dataStorage.iterator(3, 0L, l);
        DataStorage.Iterator iterator2 = dataStorage2.iterator(3, 0L, l);
        DataStorage.Iterator iterator3 = dataStorage3.iterator(3, 0L, l);
        float f3 = this.modMultiply(f, f);
        float f4 = this.negate(this.modDivide(3.0f, 2.0f));
        float f5 = this.modAdd(f2, this.modDivide(1.0f, 2.0f));
        float f6 = 1.0f;
        float f7 = 1.0f;
        while (l > 0L) {
            float f8 = iterator.getFloat();
            float f9 = iterator2.getFloat();
            float f10 = iterator3.getFloat();
            if (bl) {
                f9 = this.modMultiply(f9, f6);
                f10 = this.modMultiply(f10, f7);
            }
            float f11 = this.modAdd(f9, f10);
            f10 = this.modSubtract(f9, f10);
            f8 = this.modAdd(f8, f11);
            f11 = this.modMultiply(f11, f4);
            f10 = this.modMultiply(f10, f5);
            f11 = this.modAdd(f11, f8);
            f9 = this.modAdd(f11, f10);
            f10 = this.modSubtract(f11, f10);
            if (!bl) {
                f9 = this.modMultiply(f9, f6);
                f10 = this.modMultiply(f10, f7);
            }
            iterator.setFloat(f8);
            iterator2.setFloat(f9);
            iterator3.setFloat(f10);
            iterator.next();
            iterator2.next();
            iterator3.next();
            f6 = this.modMultiply(f6, f);
            f7 = this.modMultiply(f7, f3);
            --l;
        }
    }
}

