/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.FloatDiskDataStorage;
import org.apfloat.internal.FloatMemoryDataStorage;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class FloatDataStorageBuilder
implements DataStorageBuilder {
    public DataStorage createDataStorage(long l) throws ApfloatRuntimeException {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        if (l <= (long)apfloatContext.getMemoryTreshold()) {
            return new FloatMemoryDataStorage();
        }
        return new FloatDiskDataStorage();
    }

    public DataStorage createCachedDataStorage(long l) throws ApfloatRuntimeException {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        if (l <= apfloatContext.getMaxMemoryBlockSize()) {
            return new FloatMemoryDataStorage();
        }
        return new FloatDiskDataStorage();
    }

    public DataStorage createDataStorage(DataStorage dataStorage) throws ApfloatRuntimeException {
        ApfloatContext apfloatContext;
        long l;
        if (dataStorage instanceof FloatMemoryDataStorage && (l = dataStorage.getSize()) > (long)(apfloatContext = ApfloatContext.getContext()).getMemoryTreshold()) {
            FloatDiskDataStorage floatDiskDataStorage = new FloatDiskDataStorage();
            floatDiskDataStorage.copyFrom(dataStorage);
            dataStorage = floatDiskDataStorage;
        }
        return dataStorage;
    }
}

