/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.internal.Float3NTTConvolutionStrategy;
import org.apfloat.internal.FloatKaratsubaConvolutionStrategy;
import org.apfloat.internal.FloatMediumConvolutionStrategy;
import org.apfloat.internal.FloatShortConvolutionStrategy;
import org.apfloat.spi.ConvolutionBuilder;
import org.apfloat.spi.ConvolutionStrategy;
import org.apfloat.spi.NTTBuilder;
import org.apfloat.spi.NTTStrategy;
import org.apfloat.spi.Util;

public class FloatConvolutionBuilder
implements ConvolutionBuilder {
    private static final double LOG2_3 = Math.log(3.0) / Math.log(2.0);

    public ConvolutionStrategy createConvolution(int n, long l, long l2, long l3) {
        float f;
        long l4 = Math.min(l, l2);
        long l5 = Math.max(l, l2);
        long l6 = l + l2;
        if (l4 == 1L) {
            return new FloatShortConvolutionStrategy(n);
        }
        if (l4 <= 15L) {
            return new FloatMediumConvolutionStrategy(n);
        }
        float f2 = (float)l4 * (float)l5;
        float f3 = 6.1f * (float)Math.pow(l4, LOG2_3) * (float)l5 / (float)l4;
        if (f2 <= Math.min(f3, f = 7.4f * (float)l6 * (float)Util.log2down(l6))) {
            return new FloatMediumConvolutionStrategy(n);
        }
        if (f3 <= f) {
            return new FloatKaratsubaConvolutionStrategy(n);
        }
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        NTTBuilder nTTBuilder = apfloatContext.getBuilderFactory().getNTTBuilder();
        NTTStrategy nTTStrategy = nTTBuilder.createNTT(l6);
        return new Float3NTTConvolutionStrategy(n, nTTStrategy);
    }
}

