/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.math.BigInteger;
import java.util.RandomAccess;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.FloatCRTMath;
import org.apfloat.internal.FloatModConstants;
import org.apfloat.internal.FloatModMath;
import org.apfloat.internal.MessagePasser;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class FloatCarryCRT
extends FloatCRTMath {
    private static final long serialVersionUID = -3954870352092656433L;
    private static final FloatModMath MATH_MOD_0 = new FloatModMath();
    private static final FloatModMath MATH_MOD_1 = new FloatModMath();
    private static final FloatModMath MATH_MOD_2 = new FloatModMath();
    private static final float T0;
    private static final float T1;
    private static final float T2;
    private static final float[] M01;
    private static final float[] M02;
    private static final float[] M12;
    private static final float[] M012;
    private ParallelRunner parallelRunner;

    public FloatCarryCRT(int n) {
        super(n);
    }

    public DataStorage carryCRT(final DataStorage dataStorage, final DataStorage dataStorage2, final DataStorage dataStorage3, final long l) throws ApfloatRuntimeException {
        Object object;
        final long l2 = Math.min(l + 2L, dataStorage.getSize());
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = apfloatContext.getBuilderFactory().getDataStorageBuilder();
        final DataStorage dataStorage4 = dataStorageBuilder.createDataStorage(l * 8L);
        dataStorage4.setSize(l);
        final MessagePasser<Long, float[]> messagePasser = new MessagePasser<Long, float[]>();
        if (l2 <= Integer.MAX_VALUE && this.parallelRunner != null && dataStorage instanceof RandomAccess && dataStorage2 instanceof RandomAccess && dataStorage3 instanceof RandomAccess && dataStorage4 instanceof RandomAccess) {
            object = new ParallelRunnable(){

                public int getLength() {
                    return (int)l2;
                }

                public Runnable getRunnable(int n, int n2) {
                    return new CarryCRTRunnable(dataStorage, dataStorage2, dataStorage3, dataStorage4, l2, l, n, n2, messagePasser);
                }
            };
            this.parallelRunner.runParallel((ParallelRunnable)object);
        } else {
            new CarryCRTRunnable(dataStorage, dataStorage2, dataStorage3, dataStorage4, l2, l, 0L, l2, messagePasser).run();
        }
        object = null;
        assert ((object = messagePasser.getMessage(l2)) != null);
        assert ((object).length == 2);
        assert (object[0] == 0.0f);
        assert (object[1] == 0.0f);
        return dataStorage4;
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        this.parallelRunner = parallelRunner;
    }

    private static DataStorage.Iterator arrayIterator(final float[] fArray) {
        return new DataStorage.Iterator(){
            private int position;
            {
                this.position = fArray.length - 1;
            }

            public boolean hasNext() {
                return true;
            }

            public void next() {
                --this.position;
            }

            public float getFloat() {
                assert (this.position >= 0);
                return fArray[this.position];
            }

            public void setFloat(float f) {
                assert (this.position >= 0);
                fArray[this.position] = f;
            }
        };
    }

    private static DataStorage.Iterator compositeIterator(final DataStorage.Iterator iterator, final long l, final DataStorage.Iterator iterator2) {
        return new DataStorage.Iterator(){
            private long position;

            public boolean hasNext() {
                return this.position < l ? iterator.hasNext() : iterator2.hasNext();
            }

            public void next() {
                (this.position < l ? iterator : iterator2).next();
                ++this.position;
            }

            public float getFloat() {
                return (this.position < l ? iterator : iterator2).getFloat();
            }

            public void setFloat(float f) {
                (this.position < l ? iterator : iterator2).setFloat(f);
            }

            public void close() throws ApfloatRuntimeException {
                (this.position < l ? iterator : iterator2).close();
            }
        };
    }

    static {
        MATH_MOD_0.setModulus(FloatModConstants.MODULUS[0]);
        MATH_MOD_1.setModulus(FloatModConstants.MODULUS[1]);
        MATH_MOD_2.setModulus(FloatModConstants.MODULUS[2]);
        BigInteger bigInteger = BigInteger.valueOf(Math.abs(0x1000000L));
        BigInteger bigInteger2 = BigInteger.valueOf((long)FloatModConstants.MODULUS[0]);
        BigInteger bigInteger3 = BigInteger.valueOf((long)FloatModConstants.MODULUS[1]);
        BigInteger bigInteger4 = BigInteger.valueOf((long)FloatModConstants.MODULUS[2]);
        BigInteger bigInteger5 = bigInteger2.multiply(bigInteger3);
        BigInteger bigInteger6 = bigInteger2.multiply(bigInteger4);
        BigInteger bigInteger7 = bigInteger3.multiply(bigInteger4);
        T0 = bigInteger7.modInverse(bigInteger2).floatValue();
        T1 = bigInteger6.modInverse(bigInteger3).floatValue();
        T2 = bigInteger5.modInverse(bigInteger4).floatValue();
        M01 = new float[2];
        M02 = new float[2];
        M12 = new float[2];
        M012 = new float[3];
        BigInteger[] bigIntegerArray = bigInteger5.divideAndRemainder(bigInteger);
        FloatCarryCRT.M01[0] = bigIntegerArray[0].floatValue();
        FloatCarryCRT.M01[1] = bigIntegerArray[1].floatValue();
        bigIntegerArray = bigInteger6.divideAndRemainder(bigInteger);
        FloatCarryCRT.M02[0] = bigIntegerArray[0].floatValue();
        FloatCarryCRT.M02[1] = bigIntegerArray[1].floatValue();
        bigIntegerArray = bigInteger7.divideAndRemainder(bigInteger);
        FloatCarryCRT.M12[0] = bigIntegerArray[0].floatValue();
        FloatCarryCRT.M12[1] = bigIntegerArray[1].floatValue();
        bigIntegerArray = bigInteger2.multiply(bigInteger7).divideAndRemainder(bigInteger);
        FloatCarryCRT.M012[2] = bigIntegerArray[1].floatValue();
        bigIntegerArray = bigIntegerArray[0].divideAndRemainder(bigInteger);
        FloatCarryCRT.M012[0] = bigIntegerArray[0].floatValue();
        FloatCarryCRT.M012[1] = bigIntegerArray[1].floatValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CarryCRTRunnable
    implements Runnable {
        private DataStorage resultMod0;
        private DataStorage resultMod1;
        private DataStorage resultMod2;
        private DataStorage dataStorage;
        private long size;
        private long resultSize;
        private long offset;
        private long length;
        private MessagePasser<Long, float[]> messagePasser;

        public CarryCRTRunnable(DataStorage dataStorage, DataStorage dataStorage2, DataStorage dataStorage3, DataStorage dataStorage4, long l, long l2, long l3, long l4, MessagePasser<Long, float[]> messagePasser) {
            this.resultMod0 = dataStorage;
            this.resultMod1 = dataStorage2;
            this.resultMod2 = dataStorage3;
            this.dataStorage = dataStorage4;
            this.size = l;
            this.resultSize = l2;
            this.offset = l3;
            this.length = l4;
            this.messagePasser = messagePasser;
        }

        @Override
        public void run() {
            float f;
            long l = this.offset == 0L ? this.size - this.resultSize + 1L : 0L;
            long l2 = this.offset + this.length == this.size ? 1 : 0;
            long l3 = 1L - l2;
            long l4 = this.length - l + l2;
            long l5 = this.size - this.offset;
            long l6 = l5 - this.length;
            long l7 = this.size - this.offset - this.length + l3 + l4;
            long l8 = l7 - l4;
            DataStorage.Iterator iterator = this.resultMod0.iterator(1, l5, l6);
            DataStorage.Iterator iterator2 = this.resultMod1.iterator(1, l5, l6);
            DataStorage.Iterator iterator3 = this.resultMod2.iterator(1, l5, l6);
            DataStorage.Iterator iterator4 = this.dataStorage.iterator(2, l7, l8);
            float[] fArray = new float[3];
            float[] fArray2 = new float[3];
            float[] fArray3 = new float[3];
            for (long i = 0L; i < this.length; ++i) {
                float f2 = MATH_MOD_0.modMultiply(T0, iterator.getFloat());
                float f3 = MATH_MOD_1.modMultiply(T1, iterator2.getFloat());
                float f4 = MATH_MOD_2.modMultiply(T2, iterator3.getFloat());
                FloatCarryCRT.this.multiply(M12, f2, fArray2);
                FloatCarryCRT.this.multiply(M02, f3, fArray3);
                if (FloatCarryCRT.this.add(fArray3, fArray2) != 0.0f || FloatCarryCRT.this.compare(fArray2, M012) >= 0.0f) {
                    FloatCarryCRT.this.subtract(M012, fArray2);
                }
                FloatCarryCRT.this.multiply(M01, f4, fArray3);
                if (FloatCarryCRT.this.add(fArray3, fArray2) != 0.0f || FloatCarryCRT.this.compare(fArray2, M012) >= 0.0f) {
                    FloatCarryCRT.this.subtract(M012, fArray2);
                }
                FloatCarryCRT.this.add(fArray2, fArray);
                f = FloatCarryCRT.this.divide(fArray);
                if (i >= l) {
                    iterator4.setFloat(f);
                    iterator4.next();
                }
                iterator.next();
                iterator2.next();
                iterator3.next();
            }
            float f5 = FloatCarryCRT.this.divide(fArray);
            float f6 = fArray[2];
            assert (fArray[0] == 0.0f);
            assert (fArray[1] == 0.0f);
            if (l4 == this.length - l + 1L) {
                iterator4.setFloat(f5);
                iterator4.close();
                f5 = f6;
                assert (f6 == 0.0f);
            }
            float[] fArray4 = new float[]{f6, f5};
            if (this.offset > 0L) {
                float[] fArray5 = this.messagePasser.receiveMessage(this.offset);
                DataStorage.Iterator iterator5 = FloatCarryCRT.arrayIterator(fArray5);
                iterator4 = FloatCarryCRT.compositeIterator(this.dataStorage.iterator(3, l7, l8), l4, FloatCarryCRT.arrayIterator(fArray4));
                f = FloatCarryCRT.this.baseAdd(iterator4, iterator5, 0.0f, iterator4, fArray5.length);
                f = this.baseCarry(iterator4, f, l4);
                iterator4.close();
                assert (f == 0.0f);
            }
            this.messagePasser.sendMessage(this.offset + this.length, fArray4);
        }

        private float baseCarry(DataStorage.Iterator iterator, float f, long l) {
            for (long i = 0L; i < l && f > 0.0f; ++i) {
                f = FloatCarryCRT.this.baseAdd(iterator, null, f, iterator, 1L);
            }
            return f;
        }
    }
}

