/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.internal.FloatBaseMath;
import org.apfloat.internal.FloatRadixConstants;

public class FloatCRTMath
extends FloatBaseMath {
    private static final long serialVersionUID = 2778445457339436642L;
    private static final double INVERSE_MAX_POWER_OF_TWO_BASE = 5.960464477539063E-8;
    private double base;

    public FloatCRTMath(int n) {
        super(n);
        this.base = FloatRadixConstants.BASE[n];
    }

    public final void multiply(float[] fArray, float f, float[] fArray2) {
        double d = (double)fArray[1] * (double)f;
        float f2 = (int)(d * 5.960464477539063E-8);
        fArray2[2] = (float)(d - (double)(f2 * 1.6777216E7f));
        d = (double)fArray[0] * (double)f + (double)f2;
        f2 = (int)(d * 5.960464477539063E-8);
        fArray2[1] = (float)(d - (double)(f2 * 1.6777216E7f));
        fArray2[0] = f2;
    }

    public final float compare(float[] fArray, float[] fArray2) {
        float f = fArray[0] - fArray2[0];
        if (f != 0.0f) {
            return f;
        }
        f = fArray[1] - fArray2[1];
        if (f != 0.0f) {
            return f;
        }
        return fArray[2] - fArray2[2];
    }

    public final float add(float[] fArray, float[] fArray2) {
        double d = (double)fArray2[2] + (double)fArray[2];
        float f = d >= 1.6777216E7 ? 1 : 0;
        d = d >= 1.6777216E7 ? d - 1.6777216E7 : d;
        fArray2[2] = (float)d;
        d = (double)fArray2[1] + (double)fArray[1] + (double)f;
        f = d >= 1.6777216E7 ? 1 : 0;
        d = d >= 1.6777216E7 ? d - 1.6777216E7 : d;
        fArray2[1] = (float)d;
        d = (double)fArray2[0] + (double)fArray[0] + (double)f;
        f = d >= 1.6777216E7 ? 1 : 0;
        d = d >= 1.6777216E7 ? d - 1.6777216E7 : d;
        fArray2[0] = (float)d;
        return f;
    }

    public final void subtract(float[] fArray, float[] fArray2) {
        float f = fArray2[2] - fArray[2];
        float f2 = f < 0.0f ? 1 : 0;
        fArray2[2] = f = f < 0.0f ? f + 1.6777216E7f : f;
        f = fArray2[1] - fArray[1] - f2;
        f2 = f < 0.0f ? 1 : 0;
        fArray2[1] = f = f < 0.0f ? f + 1.6777216E7f : f;
        f = fArray2[0] - fArray[0] - f2;
        fArray2[0] = f = f < 0.0f ? f + 1.6777216E7f : f;
    }

    public final float divide(float[] fArray) {
        double d = (double)fArray[0] * 1.6777216E7 + (double)fArray[1];
        float f = (int)(d / this.base);
        float f2 = (float)(d - (double)f * this.base);
        fArray[0] = 0.0f;
        fArray[1] = f;
        d = (double)f2 * 1.6777216E7 + (double)fArray[2];
        f = (int)(d / this.base);
        f2 = (float)(d - (double)f * this.base);
        fArray[2] = f;
        return f2;
    }
}

