/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.io.Serializable;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.FloatRadixConstants;
import org.apfloat.spi.DataStorage;

public class FloatBaseMath
implements Serializable {
    private static final long serialVersionUID = -2321698097908304307L;
    private int radix;

    public FloatBaseMath(int n) {
        this.radix = n;
    }

    public float baseAdd(DataStorage.Iterator iterator, DataStorage.Iterator iterator2, float f, DataStorage.Iterator iterator3, long l) throws ApfloatRuntimeException {
        assert (iterator == null || iterator != iterator2);
        boolean bl = iterator == iterator3 || iterator2 == iterator3;
        float f2 = FloatRadixConstants.BASE[this.radix];
        for (long i = 0L; i < l; ++i) {
            double d = (double)(iterator == null ? 0.0f : iterator.getFloat()) + (double)f + (double)(iterator2 == null ? 0.0f : iterator2.getFloat());
            if (d >= (double)f2) {
                d -= (double)f2;
                f = 1.0f;
            } else {
                f = 0.0f;
            }
            iterator3.setFloat((float)d);
            if (iterator != null) {
                iterator.next();
            }
            if (iterator2 != null) {
                iterator2.next();
            }
            if (bl) continue;
            iterator3.next();
        }
        return f;
    }

    public float baseSubtract(DataStorage.Iterator iterator, DataStorage.Iterator iterator2, float f, DataStorage.Iterator iterator3, long l) throws ApfloatRuntimeException {
        assert (iterator == null || iterator != iterator2);
        assert (iterator2 != iterator3);
        float f2 = FloatRadixConstants.BASE[this.radix];
        for (long i = 0L; i < l; ++i) {
            float f3 = (iterator == null ? 0.0f : iterator.getFloat()) - f - (iterator2 == null ? 0.0f : iterator2.getFloat());
            if (f3 < 0.0f) {
                f3 += f2;
                f = 1.0f;
            } else {
                f = 0.0f;
            }
            iterator3.setFloat(f3);
            if (iterator != null && iterator != iterator3) {
                iterator.next();
            }
            if (iterator2 != null) {
                iterator2.next();
            }
            iterator3.next();
        }
        return f;
    }

    public float baseMultiplyAdd(DataStorage.Iterator iterator, DataStorage.Iterator iterator2, float f, float f2, DataStorage.Iterator iterator3, long l) throws ApfloatRuntimeException {
        assert (iterator != iterator2);
        assert (iterator != iterator3);
        double d = FloatRadixConstants.BASE[this.radix];
        for (long i = 0L; i < l; ++i) {
            double d2 = (double)iterator.getFloat() * (double)f + (double)(iterator2 == null ? 0.0f : iterator2.getFloat()) + (double)f2;
            f2 = (int)(d2 / d);
            iterator3.setFloat((float)(d2 - (double)f2 * d));
            iterator.next();
            if (iterator2 != null && iterator2 != iterator3) {
                iterator2.next();
            }
            iterator3.next();
        }
        return f2;
    }

    public float baseDivide(DataStorage.Iterator iterator, float f, float f2, DataStorage.Iterator iterator2, long l) throws ApfloatRuntimeException {
        assert (iterator != iterator2);
        double d = FloatRadixConstants.BASE[this.radix];
        double d2 = f;
        for (long i = 0L; i < l; ++i) {
            double d3 = (double)f2 * d + (double)(iterator == null ? 0.0f : iterator.getFloat());
            float f3 = (int)(d3 / d2);
            f2 = (float)(d3 - (double)f3 * d2);
            iterator2.setFloat(f3);
            if (iterator != null) {
                iterator.next();
            }
            iterator2.next();
        }
        return f2;
    }
}

