/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.util.RandomAccess;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.FloatCarryCRT;
import org.apfloat.internal.FloatModConstants;
import org.apfloat.internal.FloatModMath;
import org.apfloat.internal.ParallelNTTStrategy;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.spi.ConvolutionStrategy;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;
import org.apfloat.spi.NTTStrategy;

public class Float3NTTConvolutionStrategy
extends FloatModMath
implements ConvolutionStrategy {
    private NTTStrategy transform;
    private FloatCarryCRT carryCRT;
    private ParallelRunner parallelRunner;
    private boolean locked;

    public Float3NTTConvolutionStrategy(int n, NTTStrategy nTTStrategy) {
        this.transform = nTTStrategy;
        this.carryCRT = new FloatCarryCRT(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStorage convolute(DataStorage dataStorage, DataStorage dataStorage2, long l) throws ApfloatRuntimeException {
        DataStorage dataStorage3;
        if (dataStorage == dataStorage2) {
            return this.autoConvolute(dataStorage, l);
        }
        long l2 = this.transform.getTransformLength(dataStorage.getSize() + dataStorage2.getSize());
        this.lock(l2);
        try {
            DataStorage dataStorage4 = this.convoluteOne(dataStorage, dataStorage2, l2, 0, false);
            DataStorage dataStorage5 = this.convoluteOne(dataStorage, dataStorage2, l2, 1, false);
            DataStorage dataStorage6 = this.convoluteOne(dataStorage, dataStorage2, l2, 2, true);
            dataStorage3 = this.carryCRT.carryCRT(dataStorage4, dataStorage5, dataStorage6, l);
        }
        finally {
            this.unlock();
        }
        return dataStorage3;
    }

    private DataStorage convoluteOne(DataStorage dataStorage, DataStorage dataStorage2, long l, int n, boolean bl) throws ApfloatRuntimeException {
        DataStorage dataStorage3 = Float3NTTConvolutionStrategy.createCachedDataStorage(l);
        dataStorage3.copyFrom(dataStorage2, l);
        this.transform.transform(dataStorage3, n);
        dataStorage3 = Float3NTTConvolutionStrategy.createDataStorage(dataStorage3);
        DataStorage dataStorage4 = Float3NTTConvolutionStrategy.createCachedDataStorage(l);
        dataStorage4.copyFrom(dataStorage, l);
        this.transform.transform(dataStorage4, n);
        this.multiplyInPlace(dataStorage4, dataStorage3, n);
        this.transform.inverseTransform(dataStorage4, n, l);
        dataStorage4 = bl ? dataStorage4 : Float3NTTConvolutionStrategy.createDataStorage(dataStorage4);
        return dataStorage4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStorage autoConvolute(DataStorage dataStorage, long l) throws ApfloatRuntimeException {
        DataStorage dataStorage2;
        long l2 = this.transform.getTransformLength(dataStorage.getSize() * 2L);
        this.lock(l2);
        try {
            DataStorage dataStorage3 = this.autoConvoluteOne(dataStorage, l2, 0, false);
            DataStorage dataStorage4 = this.autoConvoluteOne(dataStorage, l2, 1, false);
            DataStorage dataStorage5 = this.autoConvoluteOne(dataStorage, l2, 2, true);
            dataStorage2 = this.carryCRT.carryCRT(dataStorage3, dataStorage4, dataStorage5, l);
        }
        finally {
            this.unlock();
        }
        return dataStorage2;
    }

    private DataStorage autoConvoluteOne(DataStorage dataStorage, long l, int n, boolean bl) throws ApfloatRuntimeException {
        DataStorage dataStorage2 = Float3NTTConvolutionStrategy.createCachedDataStorage(l);
        dataStorage2.copyFrom(dataStorage, l);
        this.transform.transform(dataStorage2, n);
        this.squareInPlace(dataStorage2, n);
        this.transform.inverseTransform(dataStorage2, n, l);
        dataStorage2 = bl ? dataStorage2 : Float3NTTConvolutionStrategy.createDataStorage(dataStorage2);
        return dataStorage2;
    }

    private void multiplyInPlace(final DataStorage dataStorage, final DataStorage dataStorage2, int n) throws ApfloatRuntimeException {
        assert (dataStorage != dataStorage2);
        final long l = dataStorage.getSize();
        this.setModulus(FloatModConstants.MODULUS[n]);
        if (l <= Integer.MAX_VALUE && this.parallelRunner != null && dataStorage instanceof RandomAccess && dataStorage2 instanceof RandomAccess) {
            ParallelRunnable parallelRunnable = new ParallelRunnable(){

                public int getLength() {
                    return (int)l;
                }

                public Runnable getRunnable(int n, int n2) {
                    return new MultiplyInPlaceRunnable(dataStorage, dataStorage2, n, n2);
                }
            };
            this.parallelRunner.runParallel(parallelRunnable);
        } else {
            new MultiplyInPlaceRunnable(dataStorage, dataStorage2, 0L, l).run();
        }
    }

    private void squareInPlace(final DataStorage dataStorage, int n) throws ApfloatRuntimeException {
        final long l = dataStorage.getSize();
        this.setModulus(FloatModConstants.MODULUS[n]);
        if (l <= Integer.MAX_VALUE && this.parallelRunner != null && dataStorage instanceof RandomAccess) {
            ParallelRunnable parallelRunnable = new ParallelRunnable(){

                public int getLength() {
                    return (int)l;
                }

                public Runnable getRunnable(int n, int n2) {
                    return new SquareInPlaceRunnable(dataStorage, n, n2);
                }
            };
            this.parallelRunner.runParallel(parallelRunnable);
        } else {
            new SquareInPlaceRunnable(dataStorage, 0L, l).run();
        }
    }

    private void lock(long l) {
        assert (!this.locked);
        if (this.transform instanceof ParallelNTTStrategy) {
            ApfloatContext apfloatContext = ApfloatContext.getContext();
            int n = apfloatContext.getNumberOfProcessors();
            this.parallelRunner = new ParallelRunner(n);
            ((ParallelNTTStrategy)this.transform).setParallelRunner(this.parallelRunner);
            this.carryCRT.setParallelRunner(this.parallelRunner);
            if (l > apfloatContext.getSharedMemoryTreshold() / 4L) {
                Object object = apfloatContext.getSharedMemoryLock();
                this.parallelRunner.lock(object);
                this.locked = true;
            }
        }
    }

    private void unlock() {
        if (this.locked) {
            this.parallelRunner.unlock();
        }
    }

    private static DataStorage createCachedDataStorage(long l) throws ApfloatRuntimeException {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = apfloatContext.getBuilderFactory().getDataStorageBuilder();
        return dataStorageBuilder.createCachedDataStorage(l * 4L);
    }

    private static DataStorage createDataStorage(DataStorage dataStorage) throws ApfloatRuntimeException {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = apfloatContext.getBuilderFactory().getDataStorageBuilder();
        return dataStorageBuilder.createDataStorage(dataStorage);
    }

    private class SquareInPlaceRunnable
    implements Runnable {
        private DataStorage sourceAndDestination;
        private long offset;
        private long length;

        public SquareInPlaceRunnable(DataStorage dataStorage, long l, long l2) {
            this.sourceAndDestination = dataStorage;
            this.offset = l;
            this.length = l2;
        }

        public void run() {
            DataStorage.Iterator iterator = this.sourceAndDestination.iterator(3, this.offset, this.offset + this.length);
            while (this.length > 0L) {
                float f = iterator.getFloat();
                iterator.setFloat(Float3NTTConvolutionStrategy.this.modMultiply(f, f));
                iterator.next();
                --this.length;
            }
        }
    }

    private class MultiplyInPlaceRunnable
    implements Runnable {
        private DataStorage sourceAndDestination;
        private DataStorage source;
        private long offset;
        private long length;

        public MultiplyInPlaceRunnable(DataStorage dataStorage, DataStorage dataStorage2, long l, long l2) {
            this.sourceAndDestination = dataStorage;
            this.source = dataStorage2;
            this.offset = l;
            this.length = l2;
        }

        public void run() {
            DataStorage.Iterator iterator = this.sourceAndDestination.iterator(3, this.offset, this.offset + this.length);
            DataStorage.Iterator iterator2 = this.source.iterator(1, this.offset, this.offset + this.length);
            while (this.length > 0L) {
                iterator.setFloat(Float3NTTConvolutionStrategy.this.modMultiply(iterator.getFloat(), iterator2.getFloat()));
                iterator.next();
                iterator2.next();
                --this.length;
            }
        }
    }
}

