/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.DoubleModConstants;
import org.apfloat.internal.DoubleParallelFNTStrategy;
import org.apfloat.internal.Scramble;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.Util;

public class DoubleTwoPassFNTStrategy
extends DoubleParallelFNTStrategy {
    public void transform(DataStorage dataStorage, int n) throws ApfloatRuntimeException {
        ArrayAccess arrayAccess;
        int n2;
        long l = dataStorage.getSize();
        if (l > 0x180000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + l + " > " + 0x180000000000L);
        }
        if (l < 2L) {
            return;
        }
        assert (l == (l & -l));
        int n3 = Util.log2down(l);
        int n4 = n3 >> 1;
        int n5 = n3 - n4;
        n4 = 1 << n4;
        n5 = 1 << n5;
        this.setModulus(DoubleModConstants.MODULUS[n]);
        double d = this.getForwardNthRoot(DoubleModConstants.PRIMITIVE_ROOT[n], l);
        double d2 = this.modPow(d, n5);
        double[] dArray = this.createWTable(d2, n4);
        int[] nArray = Scramble.createScrambleTable(n4);
        int n6 = this.getMaxMemoryBlockSize(l);
        if (n4 > n6 || n5 > n6) {
            throw new ApfloatInternalException("Not enough memory available to fit one row or column of matrix to memory; n1=" + n4 + ", n2=" + n5 + ", available=" + n6);
        }
        int n7 = n6 / n4;
        for (n2 = 0; n2 < n5; n2 += n7) {
            arrayAccess = dataStorage.getTransposedArray(3, n2, n7, n4);
            this.transformRows(n4, n7, false, arrayAccess, dArray, nArray);
            arrayAccess.close();
        }
        if (n4 != n5) {
            double d3 = this.modPow(d, n4);
            dArray = this.createWTable(d3, n5);
        }
        n7 = n6 / n5;
        for (n2 = 0; n2 < n4; n2 += n7) {
            arrayAccess = dataStorage.getArray(3, n2 * n5, n7 * n5);
            this.multiplyElements(arrayAccess, n2, n7, n5, d, 1.0);
            this.transformRows(n5, n7, false, arrayAccess, dArray, null);
            arrayAccess.close();
        }
    }

    public void inverseTransform(DataStorage dataStorage, int n, long l) throws ApfloatRuntimeException {
        ArrayAccess arrayAccess;
        int n2;
        long l2 = dataStorage.getSize();
        if (Math.max(l2, l) > 0x180000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(l2, l) + " > " + 0x180000000000L);
        }
        if (l2 < 2L) {
            return;
        }
        assert (l2 == (l2 & -l2));
        int n3 = Util.log2down(l2);
        int n4 = n3 >> 1;
        int n5 = n3 - n4;
        n4 = 1 << n4;
        n5 = 1 << n5;
        this.setModulus(DoubleModConstants.MODULUS[n]);
        double d = this.getInverseNthRoot(DoubleModConstants.PRIMITIVE_ROOT[n], l2);
        double d2 = this.modPow(d, n4);
        double d3 = this.modDivide(1.0, l);
        double[] dArray = this.createWTable(d2, n5);
        int[] nArray = Scramble.createScrambleTable(n4);
        int n6 = this.getMaxMemoryBlockSize(l2);
        if (n4 > n6 || n5 > n6) {
            throw new ApfloatInternalException("Not enough memory available to fit one row or column of matrix to memory; n1=" + n4 + ", n2=" + n5 + ", available=" + n6);
        }
        int n7 = n6 / n5;
        for (n2 = 0; n2 < n4; n2 += n7) {
            arrayAccess = dataStorage.getArray(3, n2 * n5, n7 * n5);
            this.transformRows(n5, n7, true, arrayAccess, dArray, null);
            this.multiplyElements(arrayAccess, n2, n7, n5, d, d3);
            arrayAccess.close();
        }
        if (n4 != n5) {
            for (n2 = 1; n2 < n4; ++n2) {
                dArray[n2] = dArray[2 * n2];
            }
        }
        n7 = n6 / n4;
        for (n2 = 0; n2 < n5; n2 += n7) {
            arrayAccess = dataStorage.getTransposedArray(3, n2, n7, n4);
            this.transformRows(n4, n7, true, arrayAccess, dArray, nArray);
            arrayAccess.close();
        }
    }

    private int getMaxMemoryBlockSize(long l) {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        long l2 = Util.round2down(Math.min(apfloatContext.getMaxMemoryBlockSize() / 8L, Integer.MAX_VALUE));
        int n = (int)Math.min(l, l2);
        return n;
    }
}

