/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.DoubleModConstants;
import org.apfloat.internal.DoubleModMath;
import org.apfloat.internal.DoubleScramble;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.NTTStrategy;
import org.apfloat.spi.Util;

public class DoubleTableFNTStrategy
extends DoubleModMath
implements NTTStrategy {
    public void transform(DataStorage dataStorage, int n) throws ApfloatRuntimeException {
        long l = dataStorage.getSize();
        if (l > 0x180000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + l + " > " + 0x180000000000L);
        }
        if (l > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l);
        }
        this.setModulus(DoubleModConstants.MODULUS[n]);
        double d = this.getForwardNthRoot(DoubleModConstants.PRIMITIVE_ROOT[n], l);
        double[] dArray = this.createWTable(d, (int)l);
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l);
        this.tableFNT(arrayAccess, dArray, null);
        arrayAccess.close();
    }

    public void inverseTransform(DataStorage dataStorage, int n, long l) throws ApfloatRuntimeException {
        long l2 = dataStorage.getSize();
        if (Math.max(l2, l) > 0x180000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(l2, l) + " > " + 0x180000000000L);
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l2);
        }
        this.setModulus(DoubleModConstants.MODULUS[n]);
        double d = this.getInverseNthRoot(DoubleModConstants.PRIMITIVE_ROOT[n], l2);
        double[] dArray = this.createWTable(d, (int)l2);
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l2);
        this.inverseTableFNT(arrayAccess, dArray, null);
        this.divideElements(arrayAccess, l);
        arrayAccess.close();
    }

    public long getTransformLength(long l) {
        return Util.round2up(l);
    }

    protected void tableFNT(ArrayAccess arrayAccess, double[] dArray, int[] nArray) throws ApfloatRuntimeException {
        double[] dArray2 = arrayAccess.getDoubleData();
        int n = arrayAccess.getOffset();
        int n2 = arrayAccess.getLength();
        assert (n2 == (n2 & -n2));
        if (n2 < 2) {
            return;
        }
        int n3 = 1;
        for (int i = n2 >> 1; i > 0; i >>= 1) {
            double d;
            int n4;
            int n5;
            int n6 = i << 1;
            for (n5 = n; n5 < n + n2; n5 += n6) {
                n4 = n5 + i;
                double d2 = dArray2[n5];
                d = dArray2[n4];
                dArray2[n5] = this.modAdd(d2, d);
                dArray2[n4] = this.modSubtract(d2, d);
            }
            n5 = n3;
            for (n4 = 1; n4 < i; ++n4) {
                for (int j = n + n4; j < n + n2; j += n6) {
                    int n7 = j + i;
                    d = dArray2[j];
                    double d3 = dArray2[n7];
                    dArray2[j] = this.modAdd(d, d3);
                    dArray2[n7] = this.modMultiply(dArray[n5], this.modSubtract(d, d3));
                }
                n5 += n3;
            }
            n3 <<= 1;
        }
        if (nArray != null) {
            DoubleScramble.scramble(dArray2, n, nArray);
        }
    }

    protected void inverseTableFNT(ArrayAccess arrayAccess, double[] dArray, int[] nArray) throws ApfloatRuntimeException {
        double[] dArray2 = arrayAccess.getDoubleData();
        int n = arrayAccess.getOffset();
        int n2 = arrayAccess.getLength();
        assert (n2 == (n2 & -n2));
        if (n2 < 2) {
            return;
        }
        if (nArray != null) {
            DoubleScramble.scramble(dArray2, n, nArray);
        }
        int n3 = n2;
        int n4 = 1;
        while (n2 > n4) {
            int n5;
            int n6;
            int n7 = n4 << 1;
            n3 >>= 1;
            for (n6 = n; n6 < n + n2; n6 += n7) {
                n5 = n6 + n4;
                double d = dArray2[n5];
                dArray2[n5] = this.modSubtract(dArray2[n6], d);
                dArray2[n6] = this.modAdd(dArray2[n6], d);
            }
            n6 = n3;
            for (n5 = 1; n5 < n4; ++n5) {
                for (int i = n + n5; i < n + n2; i += n7) {
                    int n8 = i + n4;
                    double d = this.modMultiply(dArray[n6], dArray2[n8]);
                    dArray2[n8] = this.modSubtract(dArray2[i], d);
                    dArray2[i] = this.modAdd(dArray2[i], d);
                }
                n6 += n3;
            }
            n4 = n7;
        }
    }

    private void divideElements(ArrayAccess arrayAccess, double d) throws ApfloatRuntimeException {
        double d2 = this.modDivide(1.0, d);
        double[] dArray = arrayAccess.getDoubleData();
        int n = arrayAccess.getLength();
        int n2 = arrayAccess.getOffset();
        for (int i = 0; i < n; ++i) {
            dArray[i + n2] = this.modMultiply(dArray[i + n2], d2);
        }
    }
}

