/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.DoubleMatrix;
import org.apfloat.internal.DoubleModConstants;
import org.apfloat.internal.DoubleParallelFNTStrategy;
import org.apfloat.internal.Scramble;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.Util;

public class DoubleSixStepFNTStrategy
extends DoubleParallelFNTStrategy {
    public void transform(DataStorage dataStorage, int n) throws ApfloatRuntimeException {
        long l = dataStorage.getSize();
        if (l > 0x180000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + l + " > " + 0x180000000000L);
        }
        if (l > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l);
        }
        if (l < 2L) {
            return;
        }
        assert (l == (l & -l));
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l);
        this.transform(arrayAccess, n);
        arrayAccess.close();
    }

    public void inverseTransform(DataStorage dataStorage, int n, long l) throws ApfloatRuntimeException {
        long l2 = dataStorage.getSize();
        if (Math.max(l2, l) > 0x180000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(l2, l) + " > " + 0x180000000000L);
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + l2);
        }
        if (l2 < 2L) {
            return;
        }
        assert (l2 == (l2 & -l2));
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)l2);
        this.inverseTransform(arrayAccess, n, l);
        arrayAccess.close();
    }

    void transform(ArrayAccess arrayAccess, int n) throws ApfloatRuntimeException {
        int n2 = arrayAccess.getLength();
        if (n2 < 2) {
            return;
        }
        assert (n2 == (n2 & -n2));
        int n3 = Util.log2down(n2);
        int n4 = n3 >> 1;
        int n5 = n3 - n4;
        n4 = 1 << n4;
        n5 = 1 << n5;
        this.setModulus(DoubleModConstants.MODULUS[n]);
        double d = this.getForwardNthRoot(DoubleModConstants.PRIMITIVE_ROOT[n], n2);
        double d2 = this.modPow(d, n5);
        double[] dArray = this.createWTable(d2, n4);
        int[] nArray = Scramble.createScrambleTable(n4);
        DoubleMatrix.transpose(arrayAccess, n4, n5);
        this.transformRows(n4, n5, false, arrayAccess, dArray, nArray);
        DoubleMatrix.transpose(arrayAccess, n5, n4);
        this.multiplyElements(arrayAccess, 0, n4, n5, d, 1.0);
        if (n4 != n5) {
            double d3 = this.modPow(d, n4);
            dArray = this.createWTable(d3, n5);
        }
        this.transformRows(n5, n4, false, arrayAccess, dArray, null);
    }

    void inverseTransform(ArrayAccess arrayAccess, int n, long l) throws ApfloatRuntimeException {
        int n2 = arrayAccess.getLength();
        if (n2 < 2) {
            return;
        }
        assert (n2 == (n2 & -n2));
        int n3 = Util.log2down(n2);
        int n4 = n3 >> 1;
        int n5 = n3 - n4;
        n4 = 1 << n4;
        n5 = 1 << n5;
        this.setModulus(DoubleModConstants.MODULUS[n]);
        double d = this.getInverseNthRoot(DoubleModConstants.PRIMITIVE_ROOT[n], n2);
        double d2 = this.modPow(d, n4);
        double d3 = this.modDivide(1.0, l);
        double[] dArray = this.createWTable(d2, n5);
        int[] nArray = Scramble.createScrambleTable(n4);
        this.transformRows(n5, n4, true, arrayAccess, dArray, null);
        this.multiplyElements(arrayAccess, 0, n4, n5, d, d3);
        DoubleMatrix.transpose(arrayAccess, n4, n5);
        if (n4 != n5) {
            for (int i = 1; i < n4; ++i) {
                dArray[i] = dArray[2 * i];
            }
        }
        this.transformRows(n4, n5, true, arrayAccess, dArray, nArray);
        DoubleMatrix.transpose(arrayAccess, n5, n4);
    }
}

