/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.DoubleTableFNTStrategy;
import org.apfloat.internal.ParallelNTTStrategy;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.spi.ArrayAccess;

public abstract class DoubleParallelFNTStrategy
extends DoubleTableFNTStrategy
implements ParallelNTTStrategy {
    protected ParallelRunner parallelRunner;

    protected DoubleParallelFNTStrategy() {
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        this.parallelRunner = parallelRunner;
    }

    protected void multiplyElements(final ArrayAccess arrayAccess, final int n, final int n2, final int n3, final double d, final double d2) throws ApfloatRuntimeException {
        ParallelRunnable parallelRunnable = new ParallelRunnable(){

            public int getLength() {
                return n2;
            }

            public Runnable getRunnable(int n4, int n22) {
                ArrayAccess arrayAccess2 = arrayAccess.subsequence(n4 * n3, n22 * n3);
                return new MultiplyRunnable(arrayAccess2, n + n4, n22, n3, d, d2);
            }
        };
        this.parallelRunner.runParallel(parallelRunnable);
    }

    protected void transformRows(final int n, final int n2, final boolean bl, final ArrayAccess arrayAccess, final double[] dArray, final int[] nArray) throws ApfloatRuntimeException {
        ParallelRunnable parallelRunnable = new ParallelRunnable(){

            public int getLength() {
                return n2;
            }

            public Runnable getRunnable(int n3, int n22) {
                ArrayAccess arrayAccess2 = arrayAccess.subsequence(n3 * n, n22 * n);
                return new TableFNTRunnable(n, bl, arrayAccess2, dArray, nArray);
            }
        };
        this.parallelRunner.runParallel(parallelRunnable);
    }

    private class MultiplyRunnable
    implements Runnable {
        private ArrayAccess arrayAccess;
        private int startRow;
        private int rows;
        private int columns;
        private double w;
        private double scaleFactor;

        public MultiplyRunnable(ArrayAccess arrayAccess, int n, int n2, int n3, double d, double d2) {
            this.arrayAccess = arrayAccess;
            this.startRow = n;
            this.rows = n2;
            this.columns = n3;
            this.w = d;
            this.scaleFactor = d2;
        }

        public void run() {
            double[] dArray = this.arrayAccess.getDoubleData();
            int n = this.arrayAccess.getOffset();
            double d = DoubleParallelFNTStrategy.this.modPow(this.w, this.startRow);
            for (int i = 0; i < this.rows; ++i) {
                double d2 = this.scaleFactor;
                int n2 = 0;
                while (n2 < this.columns) {
                    dArray[n] = DoubleParallelFNTStrategy.this.modMultiply(dArray[n], d2);
                    d2 = DoubleParallelFNTStrategy.this.modMultiply(d2, d);
                    ++n2;
                    ++n;
                }
                d = DoubleParallelFNTStrategy.this.modMultiply(d, this.w);
            }
        }
    }

    private class TableFNTRunnable
    implements Runnable {
        private int length;
        private boolean isInverse;
        private ArrayAccess arrayAccess;
        private double[] wTable;
        private int[] permutationTable;

        public TableFNTRunnable(int n, boolean bl, ArrayAccess arrayAccess, double[] dArray, int[] nArray) {
            this.length = n;
            this.isInverse = bl;
            this.arrayAccess = arrayAccess;
            this.wTable = dArray;
            this.permutationTable = nArray;
        }

        public void run() {
            int n = this.arrayAccess.getLength();
            for (int i = 0; i < n; i += this.length) {
                ArrayAccess arrayAccess = this.arrayAccess.subsequence(i, this.length);
                if (this.isInverse) {
                    DoubleParallelFNTStrategy.this.inverseTableFNT(arrayAccess, this.wTable, this.permutationTable);
                    continue;
                }
                DoubleParallelFNTStrategy.this.tableFNT(arrayAccess, this.wTable, this.permutationTable);
            }
        }
    }
}

