/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.internal.DoubleElementaryModMath;

public class DoubleModMath
extends DoubleElementaryModMath {
    public final double[] createWTable(double d, int n) {
        double[] dArray = new double[n];
        double d2 = 1.0;
        for (int i = 0; i < n; ++i) {
            dArray[i] = d2;
            d2 = this.modMultiply(d2, d);
        }
        return dArray;
    }

    public double getForwardNthRoot(double d, long l) {
        return this.modPow(d, this.getModulus() - 1.0 - (this.getModulus() - 1.0) / (double)l);
    }

    public double getInverseNthRoot(double d, long l) {
        return this.modPow(d, (this.getModulus() - 1.0) / (double)l);
    }

    public final double modInverse(double d) {
        return this.modPow(d, this.getModulus() - 2.0);
    }

    public final double modDivide(double d, double d2) {
        return this.modMultiply(d, this.modInverse(d2));
    }

    public final double negate(double d) {
        return d == 0.0 ? 0.0 : this.getModulus() - d;
    }

    public final double modPow(double d, double d2) {
        assert (d != 0.0 || d2 != 0.0);
        if (d2 == 0.0) {
            return 1.0;
        }
        if (d2 < 0.0) {
            return this.modPow(d, this.getModulus() - 1.0 + d2);
        }
        long l = (long)d2;
        while ((l & 1L) == 0L) {
            d = this.modMultiply(d, d);
            l >>= 1;
        }
        double d3 = d;
        while ((l >>= 1) > 0L) {
            d = this.modMultiply(d, d);
            if ((l & 1L) == 0L) continue;
            d3 = this.modMultiply(d3, d);
        }
        return d3;
    }
}

