/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.DoubleBaseMath;
import org.apfloat.spi.ConvolutionStrategy;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class DoubleMediumConvolutionStrategy
extends DoubleBaseMath
implements ConvolutionStrategy {
    private static final long serialVersionUID = 3566451570697893745L;

    public DoubleMediumConvolutionStrategy(int n) {
        super(n);
    }

    public DataStorage convolute(DataStorage dataStorage, DataStorage dataStorage2, long l) throws ApfloatRuntimeException {
        DataStorage dataStorage3;
        DataStorage dataStorage4;
        if (dataStorage.getSize() > dataStorage2.getSize()) {
            dataStorage4 = dataStorage2;
            dataStorage3 = dataStorage;
        } else {
            dataStorage4 = dataStorage;
            dataStorage3 = dataStorage2;
        }
        long l2 = dataStorage4.getSize();
        long l3 = dataStorage3.getSize();
        long l4 = l2 + l3;
        if (l2 > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Too long shorter number, size = " + l2);
        }
        final int n = (int)l2;
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = apfloatContext.getBuilderFactory().getDataStorageBuilder();
        DataStorage dataStorage5 = dataStorageBuilder.createDataStorage(l4 * 8L);
        dataStorage5.setSize(l4);
        DataStorage.Iterator iterator = dataStorage3.iterator(1, l3, 0L);
        DataStorage.Iterator iterator2 = dataStorage5.iterator(2, l4, 0L);
        DataStorage.Iterator iterator3 = new DataStorage.Iterator(){
            private double[] buffer;
            private int position;
            {
                this.buffer = new double[n];
                this.position = 0;
            }

            public void next() {
                ++this.position;
                this.position = this.position == n ? 0 : this.position;
            }

            public double getDouble() {
                return this.buffer[this.position];
            }

            public void setDouble(double d) {
                this.buffer[this.position] = d;
            }
        };
        for (long i = 0L; i < l3; ++i) {
            DataStorage.Iterator iterator4 = dataStorage4.iterator(1, l2, 0L);
            double d = iterator.getDouble();
            double d2 = this.baseMultiplyAdd(iterator4, iterator3, d, 0.0, iterator3, l2);
            double d3 = iterator3.getDouble();
            iterator2.setDouble(d3);
            iterator3.setDouble(d2);
            iterator3.next();
            iterator.next();
            iterator2.next();
        }
        for (int i = 0; i < n; ++i) {
            double d = iterator3.getDouble();
            iterator2.setDouble(d);
            iterator3.next();
            iterator2.next();
        }
        return dataStorage5;
    }
}

