/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.DoubleMediumConvolutionStrategy;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class DoubleKaratsubaConvolutionStrategy
extends DoubleMediumConvolutionStrategy {
    public static final int CUTOFF_POINT = 15;
    private static final long serialVersionUID = 3605808557478224821L;

    public DoubleKaratsubaConvolutionStrategy(int n) {
        super(n);
    }

    public DataStorage convolute(DataStorage dataStorage, DataStorage dataStorage2, long l) throws ApfloatRuntimeException {
        DataStorage dataStorage3;
        DataStorage dataStorage4;
        if (Math.min(dataStorage.getSize(), dataStorage2.getSize()) <= 15L) {
            return super.convolute(dataStorage, dataStorage2, l);
        }
        if (dataStorage.getSize() > dataStorage2.getSize()) {
            dataStorage4 = dataStorage2;
            dataStorage3 = dataStorage;
        } else {
            dataStorage4 = dataStorage;
            dataStorage3 = dataStorage2;
        }
        long l2 = dataStorage4.getSize();
        long l3 = dataStorage3.getSize();
        long l4 = l2 + l3;
        long l5 = l3 + 1L >> 1;
        long l6 = l3 - l5;
        long l7 = l5;
        long l8 = l2 - l5;
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = apfloatContext.getBuilderFactory().getDataStorageBuilder();
        DataStorage dataStorage5 = dataStorageBuilder.createDataStorage(l4 * 8L);
        dataStorage5.setSize(l4);
        if (l8 <= 0L) {
            long l9;
            DataStorage.Iterator iterator = dataStorage5.iterator(2, l4, 0L);
            DataStorage.Iterator iterator2 = null;
            double d = 0.0;
            long l10 = l3;
            do {
                l9 = Math.min(l10, l2);
                dataStorage = dataStorage3.subsequence(l10 - l9, l9);
                dataStorage2 = dataStorage4;
                DataStorage dataStorage6 = this.convolute(dataStorage, dataStorage2, l9 + l2);
                assert (dataStorage6.getSize() == l9 + l2);
                DataStorage.Iterator iterator3 = dataStorage6.iterator(1, l9 + l2, 0L);
                d = this.baseAdd(iterator2, iterator3, d, iterator, l2);
                iterator2 = iterator3;
            } while ((l10 -= l2) > 0L);
            d = this.baseAdd(iterator2, null, d, iterator, l9);
            assert (d == 0.0);
        } else {
            DataStorage dataStorage7 = dataStorage3.subsequence(0L, l6);
            DataStorage dataStorage8 = dataStorage3.subsequence(l6, l7);
            DataStorage dataStorage9 = dataStorage4.subsequence(0L, l8);
            DataStorage dataStorage10 = dataStorage4.subsequence(l8, l5);
            DataStorage dataStorage11 = this.add(dataStorage7, dataStorage8);
            DataStorage dataStorage12 = this.add(dataStorage9, dataStorage10);
            DataStorage dataStorage13 = this.convolute(dataStorage11, dataStorage12, dataStorage11.getSize() + dataStorage12.getSize());
            dataStorage11 = this.convolute(dataStorage7, dataStorage9, l6 + l8);
            dataStorage12 = this.convolute(dataStorage8, dataStorage10, 2L * l5);
            this.subtract(dataStorage13, dataStorage11);
            this.subtract(dataStorage13, dataStorage12);
            long l11 = dataStorage13.getSize();
            long l12 = l11 - l5;
            if (l12 > l6 + l8) {
                long l13 = l12 - l6 - l8;
                assert (this.isZero(dataStorage13, 0L));
                assert (l13 == 1L || this.isZero(dataStorage13, 1L));
                assert (l13 <= 2L);
                l12 -= l13;
                dataStorage13 = dataStorage13.subsequence(l13, l11 -= l13);
            }
            assert (dataStorage11.getSize() == l6 + l8);
            assert (dataStorage12.getSize() == 2L * l5);
            assert (l11 >= 2L * l5 && l11 <= 2L * l5 + 2L);
            assert (l12 <= l6 + l8);
            DataStorage.Iterator iterator = dataStorage11.iterator(1, l6 + l8, 0L);
            DataStorage.Iterator iterator4 = dataStorage12.iterator(1, 2L * l5, 0L);
            DataStorage.Iterator iterator5 = dataStorage13.iterator(1, l11, 0L);
            DataStorage.Iterator iterator6 = dataStorage5.iterator(2, l4, 0L);
            double d = 0.0;
            d = this.baseAdd(iterator4, null, d, iterator6, l5);
            d = this.baseAdd(iterator4, iterator5, d, iterator6, l5);
            d = this.baseAdd(iterator, iterator5, d, iterator6, l12);
            d = this.baseAdd(iterator, null, d, iterator6, l6 + l8 - l12);
            assert (d == 0.0);
        }
        return dataStorage5;
    }

    private DataStorage add(DataStorage dataStorage, DataStorage dataStorage2) {
        long l = dataStorage.getSize();
        long l2 = dataStorage2.getSize();
        assert (l <= l2);
        long l3 = l2 + 1L;
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = apfloatContext.getBuilderFactory().getDataStorageBuilder();
        DataStorage dataStorage3 = dataStorageBuilder.createDataStorage(l3 * 8L);
        dataStorage3.setSize(l3);
        DataStorage.Iterator iterator = dataStorage.iterator(1, l, 0L);
        DataStorage.Iterator iterator2 = dataStorage2.iterator(1, l2, 0L);
        DataStorage.Iterator iterator3 = dataStorage3.iterator(2, l3, 0L);
        double d = 0.0;
        d = this.baseAdd(iterator, iterator2, d, iterator3, l);
        d = this.baseAdd(iterator2, null, d, iterator3, l2 - l);
        this.baseAdd(null, null, d, iterator3, 1L);
        if (d == 0.0) {
            dataStorage3 = dataStorage3.subsequence(1L, l3 - 1L);
        }
        return dataStorage3;
    }

    private void subtract(DataStorage dataStorage, DataStorage dataStorage2) {
        long l = dataStorage.getSize();
        long l2 = dataStorage2.getSize();
        assert (l >= l2);
        DataStorage.Iterator iterator = dataStorage.iterator(3, l, 0L);
        DataStorage.Iterator iterator2 = dataStorage2.iterator(1, l2, 0L);
        DataStorage.Iterator iterator3 = iterator;
        double d = 0.0;
        d = this.baseSubtract(iterator, iterator2, d, iterator3, l2);
        d = this.baseSubtract(iterator, null, d, iterator3, l - l2);
        assert (d == 0.0);
    }

    private boolean isZero(DataStorage dataStorage, long l) {
        DataStorage.Iterator iterator = dataStorage.iterator(1, l, l + 1L);
        double d = iterator.getDouble();
        iterator.next();
        return d == 0.0;
    }
}

